% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class101-epoched_repository.R,
%   R/class102-epoched_rawvoltage.R, R/class103-epoched_voltage.R,
%   R/class104-epoched_time-frequency.R, R/class105-epoched_power.R,
%   R/class106-epoched_phase.R
\name{prepare_subject_with_epochs}
\alias{prepare_subject_with_epochs}
\alias{prepare_subject_raw_voltage_with_epochs}
\alias{prepare_subject_voltage_with_epochs}
\alias{prepare_subject_time_frequency_coefficients_with_epochs}
\alias{prepare_subject_power_with_epochs}
\alias{prepare_subject_power}
\alias{prepare_subject_phase_with_epochs}
\title{'RAVE' repository: with epochs}
\usage{
prepare_subject_with_epochs(
  subject,
  electrodes = NULL,
  reference_name = NULL,
  epoch_name = NULL,
  time_windows = NULL,
  stitch_events = NULL,
  ...,
  quiet = FALSE,
  repository_id = NULL,
  strict = TRUE
)

prepare_subject_raw_voltage_with_epochs(
  subject,
  electrodes = NULL,
  epoch_name = NULL,
  time_windows = NULL,
  stitch_events = NULL,
  ...,
  quiet = TRUE,
  repository_id = NULL,
  strict = TRUE
)

prepare_subject_voltage_with_epochs(
  subject,
  electrodes = NULL,
  reference_name = NULL,
  epoch_name = NULL,
  time_windows = NULL,
  stitch_events = NULL,
  ...,
  quiet = FALSE,
  repository_id = NULL,
  strict = TRUE
)

prepare_subject_time_frequency_coefficients_with_epochs(
  subject,
  electrodes = NULL,
  reference_name = NULL,
  epoch_name = NULL,
  time_windows = NULL,
  stitch_events = NULL,
  ...,
  quiet = FALSE,
  repository_id = NULL,
  strict = TRUE
)

prepare_subject_power_with_epochs(
  subject,
  electrodes = NULL,
  reference_name = NULL,
  epoch_name = NULL,
  time_windows = NULL,
  stitch_events = NULL,
  ...,
  quiet = FALSE,
  repository_id = NULL,
  strict = TRUE
)

prepare_subject_power(
  subject,
  electrodes = NULL,
  reference_name = NULL,
  epoch_name = NULL,
  time_windows = NULL,
  stitch_events = NULL,
  ...,
  quiet = FALSE,
  repository_id = NULL,
  strict = TRUE
)

prepare_subject_phase_with_epochs(
  subject,
  electrodes = NULL,
  reference_name = NULL,
  epoch_name = NULL,
  time_windows = NULL,
  stitch_events = NULL,
  ...,
  quiet = FALSE,
  repository_id = NULL,
  strict = TRUE
)
}
\arguments{
\item{subject}{'RAVE' subject}

\item{electrodes}{string or integers indicating electrodes to load}

\item{reference_name}{name of the reference table}

\item{epoch_name}{name of the epoch trial table}

\item{time_windows}{numeric vector with even lengths, the time start
and end of the trials, for example, \code{c(-1, 2)} means load
1 second before the trial onset and 2 seconds after trial onset}

\item{stitch_events}{events where the \code{time_windows} is based;
default is trial onset (\code{NULL})}

\item{...}{passed to \code{\link{RAVESubjectBaseRepository}} constructor}

\item{quiet}{see field \code{quiet}}

\item{repository_id}{see field \code{repository_id}}

\item{strict}{whether to check existence of subject before loading data;
default is true}
}
\value{
A \code{\link{RAVESubjectEpochRepository}} instance
}
\description{
'RAVE' repository: with epochs
}
\examples{

if( has_rave_subject("demo/DemoSubject") ) {


repository <- prepare_subject_with_epochs(
  "demo/DemoSubject", electrodes = 14:16,
  reference_name = "default", epoch_name = "auditory_onset",
  time_windows = c(-1, 2))

print(repository)

head(repository$epoch$table)

electrodes <- repository$electrode_instances

# Channel 14
e <- electrodes$e_14

# referenced voltage
voltage <- e$load_data_with_epochs("voltage")

# 6001 time points (2000 sample rate)
# 287 trials
# 1 channel
dim(voltage)

ravetools::plot_signals(t(voltage[, 1:10, 1]),
                        sample_rate = 2000,
                        ylab = "Trial",
                        main = "First 10 trials")

}
}
