% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-cmd.R
\name{cmd-external}
\alias{cmd-external}
\alias{cmd_execute}
\alias{cmd_run_r}
\title{External shell commands for 'RAVE'}
\usage{
cmd_execute(
  script,
  script_path,
  command = "bash",
  dry_run = FALSE,
  backup = TRUE,
  args = NULL,
  ...
)

cmd_run_r(
  expr,
  quoted = FALSE,
  verbose = TRUE,
  dry_run = FALSE,
  log_file = tempfile(),
  script_path = tempfile(),
  ...
)
}
\arguments{
\item{script}{the shell script}

\item{script_path}{path to run the script}

\item{command}{which command to invoke; default is \code{'bash'}}

\item{dry_run}{whether to run in dry-run mode; under such mode, the shell
command will not execute. This is useful for debugging scripts; default is
false}

\item{backup}{whether to back up the script file immediately; default is true}

\item{args}{further arguments in the shell command, especially the
'FreeSurfer' reconstruction command}

\item{...}{passed to \code{\link{system2}}, or additional arguments}

\item{expr}{expression to run as command}

\item{quoted}{whether \code{expr} is quoted; default is false}

\item{verbose}{whether to print out the command script; default is true under
dry-run mode, and false otherwise}

\item{log_file}{where should log file be stored}
}
\value{
A list of data containing the script details:
\describe{
\item{\code{script}}{script details}
\item{\code{script_path}}{where the script should/will be saved}
\item{\code{dry_run}}{whether dry-run mode is turned on}
\item{\code{log_file}}{path to the log file}
\item{\code{execute}}{a function to execute the script}
}
}
\description{
These shell commands are only tested on 'MacOS' and 'Linux'.
On 'Windows' machines, please use the 'WSL2' system.
}
