% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{rmmCheckName}
\alias{rmmCheckName}
\title{Check field names of a range model metadata list against conventions}
\usage{
rmmCheckName(
  rmm,
  cutoff_distance = 3,
  returnData = F,
  interactiveCorrections = FALSE
)
}
\arguments{
\item{rmm}{a range model metadata list}

\item{cutoff_distance}{number of allowed different characters to match standardized names}

\item{returnData}{logical. If FALSE, the function will return the (possibly) corrected rmm object.  If TRUE, the function will return a data.frame containing information on incorrect names.}

\item{interactiveCorrections}{logical. If TRUE, the user will be prompted to indicate whether the proposed correction should be accepted, thereby modifying the `rmm` object. If FALSE, suggestions will just be printed to the screen and users can edit them manually.}
}
\value{
Either an rmm list object (`returnData=FALSE`) or a data.frame containing information on possible name errors (`returnData=TRUE`).
}
\description{
Identify nonstandard fields
}
\details{
See Examples.
}
\note{
Names returned by this check may be either incorrectly named or correctly named but missing from the data dictionary.
}
\examples{
rmm <- rmmTemplate() # Make an empty template
rmm$dataPrep$biological$taxonomicHarmonization$taxonomy_source <- "The Plant List"
# Add a new, non-standard field
rmm.1 <- rmmCheckName(rmm)
# Checking the names should identify the new, non-standard field we've added ("taxonomy_source")


}
\seealso{
Other check: 
\code{\link{rmmCheckEmpty}()},
\code{\link{rmmCheckFinalize}()},
\code{\link{rmmCheckMissingNames}()},
\code{\link{rmmCheckValue}()},
\code{\link{rmmCleanNULLs}()}
}
\author{
Cory Merow <cory.merow@gmail.com>, Brian Maitner <bmaitner@gmail.com>,
}
\concept{check}
