% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_alpha.R
\name{plot_alpha}
\alias{plot_alpha}
\title{Plot for the optimal alpha}
\usage{
plot_alpha(opt_results)
}
\arguments{
\item{opt_results}{opt_results is from either \code{\link[rSDR]{optimal_alpha_boot}} or \code{\link[rSDR]{optimal_alpha_cv}}}
}
\value{
No return value, showing the mean and standard deviation of cost function for each alpha value.
}
\description{
Plot for the mean with the standard deviation of cost function and alpha
}
\examples{

library(ManifoldOptim)
library(rSDR)
utils::data("ionosphere", package = "fdm2id")
X<-as.matrix(ionosphere[,c(1:33)])
Y<-ifelse(ionosphere[,34]=='b',0,1)
Y<-matrix(Y,length(Y),1)
set.seed(2435)
# plan(multisession) will launch parallel workers running in the background
# to save running time. To shut down background workers launched this way, call
# plan(sequential)
# use all local cores except one
# future::plan(future::multisession, workers = future::availableCores() - 1)
# use 2 cores for parallel
\donttest{
future::plan("multisession", workers = 2)
opt_results<-optimal_alpha_cv(alpha.v=c(0.3, 0.5, 0.7),X=X,Y=Y,d=3,kfolds=10)
plot_alpha(opt_results=opt_results)
}
}
