% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessment_units.R
\name{assessment_units}
\alias{assessment_units}
\title{Download Assessment Unit Summary}
\usage{
assessment_units(
  assessment_unit_identifer = NULL,
  state_code = NULL,
  organization_id = NULL,
  epa_region = NULL,
  huc = NULL,
  county = NULL,
  assessment_unit_name = NULL,
  last_change_later_than_date = NULL,
  last_change_earlier_than_date = NULL,
  status_indicator = NULL,
  return_count_only = NULL,
  tidy = TRUE,
  .unnest = TRUE,
  ...
)
}
\arguments{
\item{assessment_unit_identifer}{(character) Filters returned assessment
units to one or more specific assessment units. Multiple values can be
provided. optional}

\item{state_code}{(character) Filters returned assessment units to only
those having a state code matches one in the provided list of states.
Multiple values can be provided. optional}

\item{organization_id}{(character) Filters returned assessment units to only
those having a mathcing organization ID. Multiple values can be provided.
optional}

\item{epa_region}{(character) Filters returned assessment units to only
matching EPA regions. Multiple values can be provided. optional}

\item{huc}{(character) Filters returned assessment units to only those
which have a location type of HUC and the location value matches the
provided HUC. Multiple values can be provided. optional}

\item{county}{(character) Filters returned assessment units to only those
which have a location type of county and matches the provided county.
Multiple values can be provided. optional}

\item{assessment_unit_name}{(character) Filters the returned assessment units
to matching the provided value.}

\item{last_change_later_than_date}{(character) Filters returned assessment
units to those only changed after the provided date. Must be a character
with format: \code{"yyyy-mm-dd"}. optional}

\item{last_change_earlier_than_date}{(character) Filters returned assessment
units to those only changed before the provided date. Must be a character
with format: \code{"yyyy-mm-dd"}. optional}

\item{status_indicator}{(character) Filter the returned assessment units to
those with specified status. "A" for active, "R" for retired. optional}

\item{return_count_only}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
\code{return_count_only = Y} is no longer supported.}

\item{tidy}{(logical) \code{TRUE} (default) the function returns a tidied
tibble. \code{FALSE} the function returns the raw JSON string.}

\item{.unnest}{(logical) \code{TRUE} (default) the function attempts to unnest
data to longest format possible. This defaults to \code{TRUE} for backwards
compatibility but it is suggested to use \code{FALSE}.}

\item{...}{list of curl options passed to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
When \code{tidy = TRUE} a tibble with many variables, some nested, is
returned. When \code{tidy=FALSE} a raw JSON string is returned.
}
\description{
Provides basic information about the requested assessment units.
}
\details{
One or more of the following arguments must be included:
\code{assessment_unit_identfier}, \code{state_code} or
\code{organization_id}. Multiple values are allowed for indicated arguments
and should be included as a comma separated values in the string (eg.
\code{organization_id="TCEQMAIN,DCOEE"}).
}
\note{
See \link{domain_values} to search values that can be queried.
}
\examples{

\dontrun{

## Retrieve data about a single assessment unit
assessment_units(assessment_unit_identifer = "AL03150201-0107-200")

## Retrieve data as a JSON instead
assessment_units(assessment_unit_identifer = "AL03150201-0107-200", tidy = FALSE)
}
}
