% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5.2_Taguchi_designs_Classes.R
\name{taguchiDesign.c}
\alias{taguchiDesign.c}
\title{taguchiDesign}
\description{
An R6 class representing a Taguchi experimental design.
}
\examples{

## ------------------------------------------------
## Method `taguchiDesign.c$effectPlot`
## ------------------------------------------------

tdo = taguchiDesign("L9_3")
tdo$.response(rnorm(9))
tdo$effectPlot(points = TRUE, pch = 16, lty = 3)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{A character string specifying the name of the design. Default is \code{NULL}.}

\item{\code{factors}}{A list of factors included in the Taguchi design. Each factor is typically an instance of the \code{taguchiFactor} class.}

\item{\code{design}}{A `data.frame` representing the design matrix of the experiment. This includes the levels of each factor for every run of the experiment. Default is an empty \code{data.frame}.}

\item{\code{designType}}{A character string specifying the type of Taguchi design used. Default is \code{NULL}.}

\item{\code{replic}}{A `data.frame` containing the replication information for the design. Default is an empty \code{data.frame}.}

\item{\code{response}}{A `data.frame` storing the response values collected from the experiment. Default is an empty \code{data.frame}.}

\item{\code{Type}}{A `data.frame` specifying the type of responses or factors involved in the design. Default is an empty \code{data.frame}.}

\item{\code{block}}{A `data.frame` indicating any blocking factors used in the design. Default is an empty \code{data.frame}.}

\item{\code{runOrder}}{A `data.frame` detailing the order in which the experimental runs were conducted. Default is an empty \code{data.frame}.}

\item{\code{standardOrder}}{A `data.frame` detailing the standard order of the experimental runs. Default is an empty \code{data.frame}.}

\item{\code{desireVal}}{A list storing desired values for responses in the experiment. Default is an empty list.}

\item{\code{desirability}}{A list storing desirability functions used to evaluate the outcomes of the experiment. Default is an empty list.}

\item{\code{fits}}{A `data.frame` containing model fits or other statistical summaries from the analysis of the experimental data. Default is an empty \code{data.frame}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-taguchiDesign.c-values}{\code{taguchiDesign.c$values()}}
\item \href{#method-taguchiDesign.c-units}{\code{taguchiDesign.c$units()}}
\item \href{#method-taguchiDesign.c-.factors}{\code{taguchiDesign.c$.factors()}}
\item \href{#method-taguchiDesign.c-names}{\code{taguchiDesign.c$names()}}
\item \href{#method-taguchiDesign.c-as.data.frame}{\code{taguchiDesign.c$as.data.frame()}}
\item \href{#method-taguchiDesign.c-print}{\code{taguchiDesign.c$print()}}
\item \href{#method-taguchiDesign.c-.response}{\code{taguchiDesign.c$.response()}}
\item \href{#method-taguchiDesign.c-.nfp}{\code{taguchiDesign.c$.nfp()}}
\item \href{#method-taguchiDesign.c-summary}{\code{taguchiDesign.c$summary()}}
\item \href{#method-taguchiDesign.c-effectPlot}{\code{taguchiDesign.c$effectPlot()}}
\item \href{#method-taguchiDesign.c-identity}{\code{taguchiDesign.c$identity()}}
\item \href{#method-taguchiDesign.c-clone}{\code{taguchiDesign.c$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiDesign.c-values"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiDesign.c-values}{}}}
\subsection{Method \code{values()}}{
Get and set the \code{values} for an object of class \code{taguchiDesign}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiDesign.c$values(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New value, If missing value get the \code{values}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiDesign.c-units"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiDesign.c-units}{}}}
\subsection{Method \code{units()}}{
Get and set the \code{units} for an object of class \code{taguchiDesign}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiDesign.c$units(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New units, If missing value get the \code{units}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiDesign.c-.factors"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiDesign.c-.factors}{}}}
\subsection{Method \code{.factors()}}{
Get and set the \code{factors} in an object of class \code{taguchiDesign}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiDesign.c$.factors(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New factors, If missing value get the \code{factors}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiDesign.c-names"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiDesign.c-names}{}}}
\subsection{Method \code{names()}}{
Get and set the \code{names} in an object of class \code{taguchiDesign}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiDesign.c$names(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New names, If missing value get the \code{names}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiDesign.c-as.data.frame"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiDesign.c-as.data.frame}{}}}
\subsection{Method \code{as.data.frame()}}{
Return a data frame with the information of the object \code{taguchiDesign.c}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiDesign.c$as.data.frame()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiDesign.c-print"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiDesign.c-print}{}}}
\subsection{Method \code{print()}}{
Methods for function \code{print} in Package \code{base}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiDesign.c$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiDesign.c-.response"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiDesign.c-.response}{}}}
\subsection{Method \code{.response()}}{
Get and set the the \code{response} in an object of class \code{taguchiDesign}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiDesign.c$.response(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New response, If missing value get the \code{response}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiDesign.c-.nfp"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiDesign.c-.nfp}{}}}
\subsection{Method \code{.nfp()}}{
Prints a summary of the factors attributes including their low, high, name, unit, and type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiDesign.c$.nfp()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiDesign.c-summary"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiDesign.c-summary}{}}}
\subsection{Method \code{summary()}}{
Methods for function \code{summary} in Package \code{base}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiDesign.c$summary()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiDesign.c-effectPlot"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiDesign.c-effectPlot}{}}}
\subsection{Method \code{effectPlot()}}{
Plots the effects of factors on the response variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiDesign.c$effectPlot(
  factors,
  fun = mean,
  response = NULL,
  points = FALSE,
  l.col,
  p.col,
  ld.col,
  lty,
  xlab,
  ylab,
  main,
  ylim,
  pch
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{factors}}{Factors to be plotted.}

\item{\code{fun}}{Function applied to the response variables (e.g., mean).}

\item{\code{response}}{Optional; specifies which response variables to plot.}

\item{\code{points}}{Logical; if TRUE, plots data points.}

\item{\code{l.col}}{A color for the lines.}

\item{\code{p.col}}{A color for the points.}

\item{\code{ld.col}}{A color for the dashed line.}

\item{\code{lty}}{Line type for plotting.}

\item{\code{xlab}}{Label for the x-axis.}

\item{\code{ylab}}{Label for the y-axis.}

\item{\code{main}}{Main title for the plot.}

\item{\code{ylim}}{Limits for the y-axis.}

\item{\code{pch}}{The symbol for plotting points.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{tdo = taguchiDesign("L9_3")
tdo$.response(rnorm(9))
tdo$effectPlot(points = TRUE, pch = 16, lty = 3)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiDesign.c-identity"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiDesign.c-identity}{}}}
\subsection{Method \code{identity()}}{
Calculates the alias table for a fractional factorial design and prints an easy to read summary of the defining relations such as 'I = ABCD' for a standard 2^(4-1) factorial design.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiDesign.c$identity()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiDesign.c-clone"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiDesign.c-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiDesign.c$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
