% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5.3_Taguchi_designs_Functions.R
\name{taguchiDesign}
\alias{taguchiDesign}
\title{taguchiDesign: Taguchi Designs}
\usage{
taguchiDesign(design, randomize = TRUE, replicates = 1)
}
\arguments{
\item{design}{A character string specifying the orthogonal array of the Taguchi design. The available options are:
\itemize{
  \item {`L4_2" for three two-level factors.}
  \item {`L8_2" for seven two-level factors.}
  \item {`L9_3" for four three-level factors.}
  \item {`L12_2" for 11 two-level factors.}
  \item {`L16_2" for 16 two-level factors}
  \item {`L16_4" for 16 four-level factors.}
  \item {`L18_2_3" for one two-level and seven three-level factors.}
  \item {`L25_5" for six five-level factors.}
  \item {`L27_3" for 13 three-level factors.}
  \item {`L32_2" for 32 two-level factors.}
  \item {`L32_2_4" for one two-level factor and nine four-level factors.}
  \item {`L36_2_3_a" for 11 two-level factors and 12 three-level factors.}
  \item {`L36_2_3_b" for three two-level factors and 13 three-level factors.}
  \item {`L50_2_5" for one two-level factor and eleven five-level factors.}
  \item {`L8_4_2" for one four-level factor and four two-level factors.}
  \item {`L16_4_2_a" for one four-level factor and 12 two-level factors.}
  \item {`L16_4_2_b" for two four-level factors and nine two-level factors.}
  \item {`L16_4_2_c" for three four-level factors and six two-level factors.}
  \item {`L16_4_2_d" for five four-level factors and two two-level factors.}
  \item {`L18_6_3" for one six-level factor and six three-level factors.}
}}

\item{randomize}{A logical value (\code{TRUE}/\code{FALSE}) that specifies whether to randomize the RunOrder of the design.
By default, \code{randomize} is set to \code{TRUE}.}

\item{replicates}{An integer specifying the number of replicates for each run in the design.}
}
\value{
A \code{taguchiDesign} returns an object of class \code{taguchiDesign}.
}
\description{
Function to create a taguchi design.
}
\details{
An overview of possible taguchi designs is possible with \code{taguchiChoose}.
}
\examples{
tdo <- taguchiDesign("L9_3")
tdo$values(list(A = c("material 1", "material 2", "material 3"), B = c(29, 30, 35)))
tdo$names(c("Factor 1", "Factor 2", "Factor 3", "Factor 4"))
tdo$.response(rnorm(9))
tdo$summary()
}
\seealso{
\itemize{
\item{\code{\link{facDesign}}: for 2^k factorial designs.}
\item{\code{\link{rsmDesign}}: for response surface designs.}
\item{\code{\link{fracDesign}}: for fractional factorial design.}
\item{\code{\link{pbDesign}}: for response surface designs.}
\item{\code{\link{gageRRDesign}}: for gage designs.}
}
}
