% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.3_Factorial_designs_Functions.R
\name{aliasTable}
\alias{aliasTable}
\title{aliasTable: Display an alias table}
\usage{
aliasTable(fdo, degree, print = TRUE)
}
\arguments{
\item{fdo}{An object of class \code{\link{facDesign.c}}.}

\item{degree}{Numeric value specifying the degree of interaction i.e. degree=3 means up to threeway interactions.}

\item{print}{If \code{TRUE}, the alias table will be printed. By default \code{print} is set to \code{TRUE}.}
}
\value{
The function \code{aliasTable} returns a matrix indicating the aliased effects.
}
\description{
This function generates an alias table for a factorial design object.
}
\examples{
# Create a fractional factorial design
dfrac <- fracDesign(k = 3, gen = "C = AB")
# Display the alias table for the fractional factorial design
aliasTable(dfrac)
}
\seealso{
\code{\link{fracDesign}}, \code{\link{fracChoose}}
}
