% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_dpq_distributions_adSim.R
\name{adSim}
\alias{adSim}
\title{adSim: Bootstrap-based Anderson-Darling Test for Univariate}
\usage{
adSim(x, distribution = "normal", b = 10000)
}
\arguments{
\item{x}{A numeric vector.}

\item{distribution}{A character string specifying the distribution to test. Recognized distributions include \code{`cauchy`}, \code{`exponential`}, \code{`gumbel`}, \code{`gamma`}, \code{`log-normal`}, \code{`lognormal`}, \code{`logistic`}, \code{`normal`}, and \code{`weibull`}.}

\item{b}{A numeric value indicating the number of bootstraps to perform. Allowed values range from 1000 to 1,000,000. If \code{b} is set to \code{NA}, the Anderson-Darling test will be applied without simulation. Note that higher values of \code{b} can significantly increase computation time, potentially taking hours depending on the distribution, sample size, and computer system.}
}
\value{
A list containing the following components:
\describe{
  \item{\code{distribution}}{The distribution for which the Anderson-Darling test was applied.}
  \item{\code{parameter_estimation}}{The estimated parameters for the distribution.}
  \item{\code{Anderson_Darling}}{The value of the Anderson-Darling test statistic.}
  \item{\code{p_value}}{The corresponding p-value, either simulated or from tabled values.}
  \item{\code{critical_values}}{The critical values corresponding to the 0.75, 0.90, 0.95, 0.975, and 0.99 quantiles, either simulated or from tables.}
  \item{\code{simAD}}{The bootstrap-based Anderson-Darling distribution.}
}
}
\description{
Performs the Anderson-Darling test for univariate distributions with an option for bootstrap-based p-value determination. It also allows p-value determination using tabled critical values.
}
\details{
The function first estimates the parameters for the tested distribution, typically using Maximum-Likelihood Estimation (MLE) via the \code{\link{FitDistr}} function. For normal and log-normal distributions, parameters are estimated by the mean and standard deviation. Cauchy distribution parameters are fitted by the sums of the weighted order statistic when using tabled critical values. The Anderson-Darling statistic is then calculated based on these estimated parameters.

Parametric bootstrapping generates the distribution of the Anderson-Darling test statistic, which is used to determine the p-value. This simulation-based Anderson-Darling distribution and its corresponding critical values for selected quantiles can be printed. If simulation is not performed, a p-value is obtained from tabled critical values, although no exact expressions exist except for the log-normal, normal, and exponential distributions.
}
\examples{
x <- rnorm(25, 32, 2)
adSim(x)
adSim(x, "logistic", 2000)
adSim(x, "cauchy", NA)
adSim(x, "exponential", 2000)
adSim(x, "gumbel", 2000)
}
