% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3JSobjects.R
\name{arrows3js}
\alias{arrows3js}
\title{Add arrows to a data3js object}
\usage{
arrows3js(
  data3js,
  from,
  to,
  lwd = 1,
  arrowhead_width = 0.2,
  arrowhead_length = 0.5,
  col = "black",
  mat = "lambert",
  ...
)
}
\arguments{
\item{data3js}{The data3js object}

\item{from}{nx3 matrix of coords for the arrow start points}

\item{to}{nx3 matrix of coords for the arrow end points}

\item{lwd}{line width}

\item{arrowhead_width}{arrowhead width}

\item{arrowhead_length}{arrowhead length}

\item{col}{color}

\item{mat}{material (see \code{material3js()})}

\item{...}{other arguments to pass to \code{material3js()}}
}
\value{
Returns an updated data3js object
}
\description{
Add arrows to a data3js object
}
\examples{
# Draw a set of arrows
from <- cbind(
  runif(10, 0.2, 0.8),
  runif(10, 0.2, 0.8),
  runif(10, 0.2, 0.8)
)

to <- jitter(from, amount = 0.2)

# Setup base plot
p <- plot3js(label_axes = FALSE)

# Add arrows
p <- arrows3js(
  p, from, to,
  arrowhead_length = 0.06,
  arrowhead_width = 0.04,
  lwd = 0.01
)

# View the plot
r3js(p, translation = c(0, 0, 0.15), zoom = 2)

}
\seealso{
Other plot components: 
\code{\link{axis3js}()},
\code{\link{box3js}()},
\code{\link{grid3js}()},
\code{\link{legend3js}()},
\code{\link{light3js}()},
\code{\link{lines3js}()},
\code{\link{mtext3js}()},
\code{\link{points3js}()},
\code{\link{segments3js}()},
\code{\link{shape3js}()},
\code{\link{sphere3js}()},
\code{\link{surface3js}()},
\code{\link{text3js}()},
\code{\link{triangle3js}()}
}
\concept{plot components}
