% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagCharAA.R
\name{diagCharAA}
\alias{diagCharAA}
\title{Identification of diagnostic molecular characters in amino acid alignments
for the delineation of taxa}
\usage{
diagCharAA(AAbin, taxVector = dimnames(AAbin)[[1]], taxOfInt = "all",
  types = c("type1", "type2", "type3"), gapValid = TRUE)
}
\arguments{
\item{AAbin}{An object (the amino acid alignment) of class 'AAbin'.}

\item{taxVector}{The taxon vector. Default assumes that each row in the
alignment belongs to a different taxon.}

\item{taxOfInt}{A vector containing the taxa for which diagnostic
molecular characters shall be extracted. Default is "all".}

\item{types}{A vector containing the types of diagnostic molecular
characters that shall be extracted. The types can be "all" or any
combination of "type1", "type2", "type3" and "type4". Default is "type1",
"type 2" and "type3".}

\item{gapValid}{Boolean variable denoting if a gap can be a characteristic
state for taxon i (and taxon l in case of type 4). Default is \code{TRUE}.}
}
\value{
\code{diagCharAA} returns a list, where each entry belongs to one
taxon of interest. Each taxon of interest has a set of diagnostic
molecular characters (position, type, characteristic states for taxon of
interest, compared taxa) assigned to it.
\code{type1} means that the character is suitable to distinguish each
individual of the taxon of interest from all individuals of the remaining
taxa, and that it is fixed for one state in the taxon of interest.
\code{type2} means that the character is suitable to distinguish each
individual of the taxon of interest from all individuals of the remaining
taxa, and that it is not fixed for one state in the taxon of interest.
\code{type3} means that the character is suitable to distinguish some (but
not all) individuals of the taxon of interest from all individuals of the
remaining taxa.
\code{type4} means that the character is suitable to distinguish each
individual of the taxon of interest from all individuals of at least one
(but not all) other taxon while being fixed in both the taxon of interest
and the compared taxa.

\code{diagCharAA} returns for each taxon of interest the following elements:
\item{position}{The positions of its diagnostic molecular characters.}
\item{type}{The types of the diagnostic molecular characters.}
\item{states}{The states that are characteristic for the taxon i of interest,
i.e. states that are distinct from "X" and unique to the taxon of interest
(in case of type 1, 2 or 3), or fixed in the taxon of interest (type 4), resp.}
\item{compared taxa}{Only relevant for type 4 characters. It contains the
name x if the character is found to be a type 4 character of the taxon of
interest when being compared to taxon x.}
}
\description{
This function is a tool for an automated identification of diagnostic
molecular characters that allow to distinguish taxa within an amino acid
alignment. For each taxon given in \code{taxOfInt}, it identifies the
diagnostic characters and returns their alignment positions, their types,
the states that are characteristic for the taxon of interest and
(in case of type 4 characters) the taxon that it was compared with.
}
\examples{
#using a dataset from spider
#install.packages("spider")
#install.packages("ape")
library(spider)
library(ape)
data("anoteropsis")
anoTax <- sapply(strsplit(dimnames(anoteropsis)[[1]], split="_"),
 function(x) paste(x[1], x[2], sep="_"))
anoteropsis_AA <- trans(anoteropsis,code=1,codonstart=2)
diagCharAA(anoteropsis_AA, anoTax, taxOfInt="all")
diagCharAA(anoteropsis_AA, anoTax, taxOfInt="Artoria_flavimanus", types=c("type1","type2"))
}
\references{
Kuehn, A.L., Haase, M. 2019. QUIDDICH: QUick IDentification of
DIagnostic CHaracters.
}
\author{
A. Luise Kuehn <luise.kuehn@uni-greifswald.de>
}
