% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stroop.R
\docType{data}
\name{stroop}
\alias{stroop}
\title{Stroop Dataset from Von Bastian et al. (2015)}
\format{
A \code{data.frame} of 11245 rows and 7 columns
\describe{
  \item{ID}{Factor giving the participant ID: 1-121}
  \item{congruency}{Factor giving one of the two conditions: congruent and incongruent}
  \item{rtMS}{Numeric values of the response times in milliseconds}
  \item{accuracy}{Numeric values giving the accuracy of the response, here only 1 = correct}
  \item{cond}{Factor giving the condition: 1 = congruent, 2 = incongruent}
  \item{trial}{Numeric values indicating the trial number of the participant}
  \item{rtS}{Numeric values giving the response time in seconds}
  }
}
\source{
Von Bastian, C. C., Souza, A. S., & Gade, M. (2016). No evidence for
  bilingual cognitive advantages: A test of four hypotheses. Journal of
  Experimental Psychology: General, 145(2), 246., retrieved from
  \url{https://raw.githubusercontent.com/PerceptionCognitionLab/data0/master/contexteffects/FlankerStroopSimon/LEF_stroop.csv}
}
\usage{
stroop
}
\description{
The dataset from on Von Bastian et al. (2015) on the Stroop task.
}
\details{
In a Stroop task, average response times are compared across conditions.
Participants get exposed to word stimuli and are instructed to indicate the
font colour of the word. The word itself is also a colour word and is either
\strong{congruent} with the font colour or \strong{incongruent}. For example, the stimulus word
“red” in blue font would constitute the incongruent condition, whereas the
word “red” in red font would constitute the congruent condition.
}
\keyword{datasets}
