% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qm_matching.R
\name{qm_matching}
\alias{qm_matching}
\title{Constructor for qm_matching objects}
\usage{
qm_matching(group_labels, unassigned_labels = NULL, ids = NULL)
}
\arguments{
\item{group_labels}{a vector containing each unit's group label.}

\item{unassigned_labels}{labels that denote unassigned units. If \code{NULL}, \code{NA} values in
\code{group_labels} are used to denote unassigned points.}

\item{ids}{IDs of the units. Should be a vector of the same length as
\code{group_labels} or \code{NULL}. If \code{NULL}, the IDs are set to
\code{1:length(group_labels)}.}
}
\value{
Returns a \code{qm_matching} object with the matching described by the
   provided labels.
}
\description{
The \code{qm_matching} function constructs a \code{qm_matching} object from
existing matched group labels. The function does not derive matchings from
sets of data points; see \code{\link{quickmatch}} for that functionality.
}
\details{
\code{qm_matching} objects are based on integer vectors, and it indexes
matched groups starting with zero. The \code{qm_matching} class inherits
from the \code{\link[scclust]{scclust}} class.
}
\examples{
# 10 units in 3 matched groups
matches1 <- qm_matching(c("A", "A", "B", "C", "B",
                          "C", "C", "A", "B", "B"))

# 8 units in 3 matched groups, 2 units unassigned
matches2 <- qm_matching(c(1, 1, 2, 3, 2,
                          NA, 3, 1, NA, 2))

# Custom labels indicating unassiged units
matches3 <- qm_matching(c("A", "A", "B", "C", "NONE",
                          "C", "C", "NONE", "B", "B"),
                        unassigned_labels = "NONE")

# Two different labels indicating unassiged units
matches4 <- qm_matching(c("A", "A", "B", "C", "NONE",
                          "C", "C", "0", "B", "B"),
                        unassigned_labels = c("NONE", "0"))

# Custom unit IDs
matches5 <- qm_matching(c("A", "A", "B", "C", "B",
                          "C", "C", "A", "B", "B"),
                        ids = letters[1:10])

}
