% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BOW.R
\name{BOW_test}
\alias{BOW_test}
\title{Transform New Text into a Document-Feature Matrix}
\usage{
BOW_test(doc, fit)
}
\arguments{
\item{doc}{A character vector of new documents to be processed.}

\item{fit}{A fitted BoW object returned by \code{BOW_train()}.}
}
\value{
A quanteda \code{dfm} aligned to the training features.
}
\description{
This function takes a character vector of new documents and transforms it
into a DFM that has the exact same features as a pre-fitted training DFM,
ensuring consistency for prediction.
}
\examples{
train_txt <- c("apple orange banana", "apple apple")
fit <- BOW_train(train_txt, weighting_scheme = "bow")
new_txt <- c("banana pear", "orange apple")
test_dfm <- BOW_test(new_txt, fit)
test_dfm
}
