% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-other.R
\name{newPlot}
\alias{newPlot}
\alias{dev.useRSGD}
\title{Open a new plotting window}
\usage{
newPlot(noRStudioGD = TRUE, ..., verbose = getOption("quickPlot.verbose"))

dev.useRSGD(useRSGD = FALSE)
}
\arguments{
\item{noRStudioGD}{Logical Passed to \code{dev.new}. Default is TRUE to avoid using
RStudio graphics device, which is slow.}

\item{...}{Additional arguments.}

\item{verbose}{Numeric or logical. If \code{TRUE} or \verb{>0}, then messages will be
shown. If \code{FALSE} or \code{0}, most messages will be suppressed.}

\item{useRSGD}{Logical indicating whether the default device should be the
RStudio graphic device, or the platform default (\code{quartz}
on macOS; \code{windows} on Windows; \code{x11} on others, e.g., Linux).}
}
\description{
Open a new plotting window
}
\note{
\code{\link[=dev.new]{dev.new()}} is supposed to be the correct way to open a new
window in a platform-generic way; however, does not work in RStudio
(\href{https://github.com/PredictiveEcology/SpaDES/issues/116}{SpaDES#116}).
Use \code{dev.useRSGD(FALSE)} to avoid RStudio for the remainder of this session,
and \code{dev.useRSGD(TRUE)} to use the RStudio graphics device.
(This sets the default device via the \code{device} option.)
}
\examples{
\dontrun{
## set option to avoid using Rstudio graphics device
dev.useRSGD(FALSE)

## open new plotting window
newPlot()
}

}
\seealso{
\code{\link[=dev]{dev()}}.
}
\author{
Eliot McIntire and Alex Chubaty
}
