% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{shifts_by}
\alias{shifts_by}
\title{Shift Data (i.e., lag/lead) by Group}
\usage{
shifts_by(data, vrb.nm, grp.nm, n, undefined = NA, suffix)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables.}

\item{grp.nm}{character vector of colnames from \code{data} specifying the
groups.}

\item{n}{integer vector of length 1. Specifies the direction and magnitude of
the shift. See details.}

\item{undefined}{atomic vector of length 1 (probably makes sense to be the
same typeof as the vectors in \code{data[vrb.nm]}). Specifies what to
insert for undefined values after the shifting takes place. See details.}

\item{suffix}{character vector of length 1 specifying the string to append to
the end of the colnames of the return object. The default depends on the
\code{n} argument: 1) if \code{n} < 0, then \code{suffix} =
\code{paste0("_gw", -n)}, 2) if \code{n} > 0, then \code{suffix} =
\code{paste0("_dw", +n)}, 3) if \code{n} = 0, then \code{suffix} = "".}
}
\value{
data.frame of shifted data by group with colnames specified by
  \code{suffix}.
}
\description{
\code{shifts_by} shifts rows of data down (\code{n} < 0) for lags or up (\code{n}
> 0) for leads replacing the undefined data with a user-defined value (e.g.,
NA). The number of rows shifted is equal to \code{abs(n)}. It is assumed that
\code{data[vrb.nm]} is already sorted within each group by time such that the
first row for that group is earliest in time and the last row for that group
is the latest in time. The groups can be specified by multiple columns in
\code{data} (e.g., \code{grp.nm} with length > 1), and \code{interaction}
will be implicitly called to create the groups.
}
\details{
If \code{n} is negative, then \code{shifts_by} inserts \code{undefined} into
the first \code{abs(n)} rows of \code{data[vrb.nm]} for each group, shifting
all other rows of \code{x} down \code{abs(n)} positions, and then dropping
the last \code{abs(n)} row of \code{data[vrb.nm]} to preserve the original
nrow of each group. If \code{n} is positive, then \code{shifts_by} drops the
first \code{abs(n)} rows of \code{x} for each group, shifting all other rows
of \code{data[vrb.nm]} up \code{abs(n)} positions, and then inserts
\code{undefined} into the last \code{abs(n)} rows of \code{x} to preserve the
original length of each group. If \code{n} is zero, then \code{shifts_by}
simply returns \code{data[vrb.nm]}.

It is recommended to use \code{L} when specifying \code{n} to prevent
problems with floating point numbers. \code{shifts_by} tries to circumvent
this issue by a call to \code{round} within \code{shifts_by} if \code{n} is
not an integer; however that is not a complete fail safe. The problem is that
\code{as.integer(n)} implicit in \code{shifts_by} truncates rather than
rounds.
}
\examples{
shifts_by(data = ChickWeight, vrb.nm = c("weight","Time"), grp.nm = "Chick", n = -1L)
shifts_by(data = mtcars, vrb.nm = c("disp","mpg"), grp.nm = c("vs","am"), n = 1L)
shifts_by(data = as.data.frame(CO2), vrb.nm = c("conc","uptake"),
   grp.nm = c("Type","Treatment"), n = 2L) # multiple grouping columns
}
\seealso{
\code{\link{shift_by}}
   \code{\link{shifts}}
   \code{\link{shift}}
}
