% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdp_to_pattern.R
\name{sdp_to_pattern}
\alias{sdp_to_pattern}
\alias{sdp_to_logical}
\title{Convert sdp to pattern}
\usage{
sdp_to_pattern(sdp, haplos, symmetric = TRUE)

sdp_to_logical(sdp, haplos, symmetric = TRUE)
}
\arguments{
\item{sdp}{vector of sdp values}

\item{haplos}{letter codes for haplotypes (required)}

\item{symmetric}{make patterns symmetric if \code{TRUE}}
}
\value{
vector of letter patterns
}
\description{
Convert strain distribution pattern (sdp) to letter pattern.
}
\examples{
dirpath <- "https://raw.githubusercontent.com/rqtl/qtl2data/master/DOex"

\donttest{
# Download SNP info for DOex from web and read as RDS.
tmpfile <- tempfile()
download.file(file.path(dirpath, "c2_snpinfo.rds"), tmpfile, quiet=TRUE)
snpinfo <- readRDS(tmpfile)
unlink(tmpfile)
snpinfo <- dplyr::rename(snpinfo, pos = pos_Mbp)

# Extract strain distribution pattern.
sdp <- snpinfo$sdp
# Find out how many alleles.
nallele <- ceiling(log2(max(sdp)))
out <- sdp_to_pattern(sdp, LETTERS[seq_len(nallele)])
# Show most frequent patterns. 
head(rev(sort(c(table(out)))))
}

}
\author{
Brian S Yandell, \email{brian.yandell@wisc.edu}
}
\keyword{utilities}
