# two-panel plot with both snp asso and genes
# (for a single chromosome)
#
# calls ggplot_snpasso and ggplot_genes
# internal function that is called by ggplot_snpasso
ggplot_snpasso_and_genes <-
    function(scan1output, snpinfo, show_all_snps=TRUE,
             drop_hilit=NA, col_hilit="violetred", col="darkslateblue",
             gap=25, minlod=0,
             genes, minrow=4, padding=0.2,
             colors=c("black", "red3", "green4", "blue3", "orange"),
             scale_pos=1, start_field="start", stop_field="stop",
             strand_field="strand", name_field="Name",
             top_panel_prop=0.65, xlim=NULL, xaxt="s",
             xlab=NULL, ...)
{
    if(is.null(xlim)) xlim <- range(snpinfo$pos)

    if(is.null(xlab)) {
        if(length(unique(snpinfo$chr))==1)
            xlab <- paste("Chr", snpinfo$chr[1], "position (Mbp)")
        else
            xlab <- "Position (Mbp)"
    }

    # 2 x 1 panels
    grid::grid.newpage()
    grid::pushViewport(
      grid::viewport(
        layout = grid::grid.layout(nrow = 2,
                                   heights=c(top_panel_prop,
                                             1-top_panel_prop))))
    
    p1 <- ggplot_snpasso(scan1output, snpinfo, show_all_snps=show_all_snps,
                 drop_hilit=drop_hilit, col_hilit=col_hilit, col=col,
                 gap=gap, minlod=minlod, xlim=xlim, xaxt="n", xlab="",
                 ...) +
      ggplot2::theme(axis.title.x = ggplot2::element_blank(),
                     axis.text.x  = ggplot2::element_blank(),
                     axis.ticks.x = ggplot2::element_blank())

    p2 <- ggplot_genes(genes, minrow=minrow, padding=padding, colors=colors,
               scale_pos=scale_pos, start_field=start_field, stop_field=stop_field,
               strand_field=strand_field, name_field=name_field, xlim=xlim,
               xaxt=xaxt, xlab=xlab, ...)
    print(p1, 
          vp = grid::viewport(layout.pos.row = 1,
                              layout.pos.col = 1))
    print(p2,
          vp = grid::viewport(layout.pos.row = 2,
                              layout.pos.col = 1))
}
