% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_calculation.R
\name{pwr.contrast}
\alias{pwr.contrast}
\title{Power of contrasts}
\usage{
pwr.contrast(
  object,
  which,
  by = NULL,
  contrast = c("pairwise", "poly", "trt.vs.ctrl"),
  sig.level = 0.05,
  p.adj = FALSE,
  alternative = c("two.sided", "one.sided"),
  strict = TRUE
)
}
\arguments{
\item{object}{a design object created in pwr4exp}

\item{which}{the factor of interest. Multiple factors can be combined using
\code{:} or \code{*}, e.g., \code{"facA*facB"}, which represents a single factor that combines
the levels of both factors.}

\item{by}{the variable to condition on}

\item{contrast}{A character string specifying the contrast method, one of
"pairwise", "poly", or "trt.vs.ctrl". Alternatively, a numeric vector defining
a single contrast or a (named) list of vectors specifying multiple custom contrasts.
If a list is provided, each element must be a vector whose length matches the
number of levels of the factor in each \code{by} group. In multi-factor scenarios,
factor levels are combined and treated as a single factor.}

\item{sig.level}{significance level, default 0.05}

\item{p.adj}{whether the sig.level should be adjusted using the Bonferroni method, default FALSE}

\item{alternative}{one- or two-sided test. Can be abbreviated.}

\item{strict}{use strict interpretation in two-sided case}
}
\value{
For each \code{by} condition, returns a data frame containing the contrast value (\code{effect}),
degrees of freedom (\code{df}), type I error rate (\code{sig.level}), \code{power}, and the test direction
(by \code{alternative}).
When multiple \code{by} conditions are present, the results are returned as a list.
}
\description{
Computes the statistical power of t-tests for comparisons among means.
}
\examples{
rcbd <- designRCBD(
  treatments = c(2, 2),
  label = list(facA = c("1", "2"), facB = c("1", "2")),
  blocks = 12,
  formula = ~ facA*facB + (1|block),
  means = c(32, 35, 30, 37),
  vcomp = 4,
  sigma2 = 6
)

# If contrast is not specified, pairwise comparisons are conducted
pwr.contrast(rcbd, which = "facA") # Marginal effect of facA
pwr.contrast(rcbd, which = "facA", by = "facB") # Conditional effect of facA within levels of facB

# Custom contrast vector, identical to pairwise comparison
pwr.contrast(rcbd, which = "facA", contrast = c(1, -1))
pwr.contrast(rcbd, which = "facA", by = "facB", contrast = c(1, -1))

# A single factor combining two factors
pwr.contrast(
  rcbd,
  which = "facA*facB",
  contrast = list(
    A1B1vs.A2B1 = c(1, -1, 0, 0),
    A1B1vs.A2B2 = c(1, 0, 0, -1)
  )
)
}
