% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived_inductDelay.R
\docType{data}
\name{derived_inductDelay}
\alias{derived_inductDelay}
\title{Derived Induction Delay Data}
\format{
A tibble with 2,492 rows and 3 variables:
\describe{
\item{who}{Patient ID}
\item{treatment}{What treatment is prescribed: "Inpatient BUP",
"Inpatient NR-NTX", "Methadone", "Outpatient BUP", "Outpatient BUP + EMM",
"Outpatient BUP + SMM"}
\item{inductDelay}{How many days after being assigned to a treatment arm
did the participant receive their first dose of study drug? Missing
values indicate that the subject never received their first dose.}
}
}
\usage{
data(derived_inductDelay)
}
\description{
This data set measures the number of days from a participant's
randomization until they received their first dose of study drug.
}
\details{
This data set is a derived data set. The inputs are the treatment
and randomization data sets. The code to calculate the induction delay is
given in \code{scripts/create_inductDelay_20210729.R}. The treatment arm is
also included in this data set because the induction delay depends on the
type of treatment. For example, inpatient treatment arms may have
different protocols than outpatient treatment arms for determining how
many days the subject must wait after randomization before treatment.
}
\keyword{datasets}
