% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete_chat.R
\name{complete_chat}
\alias{complete_chat}
\title{Complete an LLM Chat}
\usage{
complete_chat(
  prompt,
  model = "gpt-3.5-turbo",
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  max_tokens = 1,
  temperature = 0,
  seed = NULL,
  parallel = FALSE
)
}
\arguments{
\item{prompt}{The prompt}

\item{model}{Which OpenAI model to use. Defaults to 'gpt-3.5-turbo'}

\item{openai_api_key}{Your API key. By default, looks for a system environment variable called "OPENAI_API_KEY" (recommended option). Otherwise, it will prompt you to enter the API key as an argument.}

\item{max_tokens}{How many tokens (roughly 4 characters of text) should the model return? Defaults to a single token (next word prediction).}

\item{temperature}{A numeric between 0 and 2 When set to zero, the model will always return the most probable next token. For values greater than zero, the model selects the next word probabilistically.}

\item{seed}{An integer. If specified, the OpenAI API will "make a best effort to sample deterministically".}

\item{parallel}{TRUE to submit API requests in parallel. Setting to FALSE can reduce rate limit errors at the expense of longer runtime.}
}
\value{
If max_tokens = 1, returns a dataframe with the 5 most likely next-word responses and their probabilities. If max_tokens > 1, returns a single string of text generated by the model.
}
\description{
Submits a prompt to OpenAI's "Chat" API endpoint and formats the response into a string or tidy dataframe.
}
\examples{
\dontrun{
format_chat('Are frogs sentient? Yes or No.') |> complete_chat()
format_chat('Write a haiku about frogs.') |> complete_chat(max_tokens = 100)
}
}
