% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim_lhmm}
\alias{sim_lhmm}
\title{Simulating action sequences using LHMM}
\usage{
sim_lhmm(n, paras, min_len, mean_len, return_state = TRUE)
}
\arguments{
\item{n}{number of action sequences to be generated}

\item{paras}{a list containing specified LHMM parameters: \code{para_a}, \code{para_b}, \code{para_alpha},
\code{para_beta}, and \code{para_P1}.}

\item{min_len}{minimum length of generated sequences}

\item{mean_len}{mean length of generated sequences}

\item{return_state}{logical. Whether generated hidden state sequences should be returned or not.}
}
\value{
If \code{return_state = TRUE}, \code{sim_hmm} returns a list of three elements
\tabular{ll}{
\code{seqs} \tab a list of \code{n} generated action sequences \cr
\tab \cr
\code{theta} \tab latent traits as a vector of length \code{n} \cr
\tab \cr
\code{state_seqs} \tab a list of \code{n} hidden state sequences
}
If \code{return_state = FALSE}, the returned list only contains \code{seqs} and \code{theta}.
}
\description{
\code{sim_lhmm} generate \code{n} action sequences from LHMM based on given parameters.
The lengths of the generated sequences are simulated from a Poission distribution with
mean \code{mean_len} and at least \code{min_len}. The latent trait is generated from standard
normal.
}
\examples{
paras <- sim_lhmm_paras(5,2)
sim_data <- sim_lhmm(20, paras, 4, 10)

}
