% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_default_solver.R
\name{add_default_solver}
\alias{add_default_solver}
\title{Add default solver}
\usage{
add_default_solver(x, ...)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} object.}

\item{...}{arguments passed to the solver.}
}
\value{
An updated \code{\link[=problem]{problem()}} object with the solver added to it.
}
\description{
Specify that the best solver currently available should be
used to solve a conservation planning problem.
}
\details{
Ranked from best to worst, the available solvers that can be used are:
\code{\link[=add_gurobi_solver]{add_gurobi_solver()}}, \code{\link[=add_cplex_solver]{add_cplex_solver()}}, \code{\link[=add_cbc_solver]{add_cbc_solver()}},
\code{\link[=add_highs_solver]{add_highs_solver()}}, \code{\link[=add_lpsymphony_solver]{add_lpsymphony_solver()}}, and finally
\code{\link[=add_rsymphony_solver]{add_rsymphony_solver()}}.
For information on the performance of different solvers,
please see Schuster \emph{et al.} (2020).
}
\references{
Schuster R, Hanson JO, Strimas-Mackey M, and Bennett JR (2020). Exact
integer linear programming solvers outperform simulated annealing for
solving conservation planning problems. \emph{PeerJ}, 8: e9258.
}
\seealso{
See \link{solvers} for an overview of all functions for adding a solver.

Other functions for adding solvers:
\code{\link{add_cbc_solver}()},
\code{\link{add_cplex_solver}()},
\code{\link{add_gurobi_solver}()},
\code{\link{add_highs_solver}()},
\code{\link{add_lsymphony_solver}},
\code{\link{add_rsymphony_solver}()}
}
\concept{solvers}
