% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qprimarycensored.R
\name{qprimarycensored}
\alias{qprimarycensored}
\alias{qpcens}
\title{Compute quantiles corresponding to target probabilities for primary event
censored delays}
\usage{
qprimarycensored(
  p,
  pdist,
  pwindow = 1,
  D = Inf,
  dprimary = stats::dunif,
  dprimary_args = list(),
  ...
)

qpcens(
  p,
  pdist,
  pwindow = 1,
  D = Inf,
  dprimary = stats::dunif,
  dprimary_args = list(),
  ...
)
}
\arguments{
\item{p}{Vector of probabilities between 0 and 1 for which to compute
corresponding quantiles}

\item{pdist}{Distribution function (CDF). The package can identify base R
distributions for potential analytical solutions. For non-base R functions,
users can apply \code{\link[=add_name_attribute]{add_name_attribute()}} to yield properly tagged
functions if they wish to leverage the analytical solutions.}

\item{pwindow}{Primary event window}

\item{D}{Maximum delay (truncation point). If finite, the distribution is
truncated at D. If set to Inf, no truncation is applied. Defaults to Inf.}

\item{dprimary}{Function to generate the probability density function
(PDF) of primary event times. This function should take a value \code{x} and a
\code{pwindow} parameter, and return a probability density. It should be
normalized to integrate to 1 over [0, pwindow]. Defaults to a uniform
distribution over [0, pwindow]. Users can provide custom functions or use
helper functions like \code{dexpgrowth} for an exponential growth distribution.
See \code{\link[=pcd_primary_distributions]{pcd_primary_distributions()}} for examples. The package can identify
base R distributions for potential analytical solutions. For non-base R
functions, users can apply \code{\link[=add_name_attribute]{add_name_attribute()}} to yield properly tagged
functions if they wish to leverage analytical solutions.}

\item{dprimary_args}{List of additional arguments to be passed to
dprimary. For example, when using \code{dexpgrowth}, you would
pass \code{list(min = 0, max = pwindow, r = 0.2)} to set the minimum, maximum,
and rate parameters}

\item{...}{Additional arguments to be passed to pdist}
}
\value{
Vector of delay values (quantiles) corresponding to the input
probabilities
}
\description{
This function computes the quantiles (delay values) that correspond to
specified probabilities in the primary event censored distribution. For a
given probability p, it computes the delay value q such that the cumulative
probability up to q equals p in the primary event censored distribution.
The distribution accounts for both the delay distribution and the primary
event timing distribution.
}
\details{
For each probability, the function finds the delay value where that
proportion of events have occurred by that time in the primary event
censored distribution. This is done by inverting the cumulative
distribution function.

The function creates a \code{primarycensored} object using \code{\link[=new_pcens]{new_pcens()}} and then
computes the quantiles using \code{\link[=pcens_quantile]{pcens_quantile()}}. This approach allows for
analytical solutions when available, falling back to numerical methods when
necessary.

For example, if p = 0.5, the function returns the median delay - the value
where 50\% of censored events occur by this time and 50\% occur after.

See \code{methods(pcens_quantile)} for which combinations have analytical
solutions implemented.
}
\examples{
# Compute delays where 25\%, 50\%, and 75\% of events occur by (quartiles)
# Using lognormal delays with uniform primary events
qprimarycensored(c(0.25, 0.5, 0.75), plnorm, meanlog = 0, sdlog = 1)

# Same quartiles but with exponential growth in primary events
qprimarycensored(
  c(0.25, 0.5, 0.75), plnorm,
  dprimary = dexpgrowth,
  dprimary_args = list(r = 0.2), meanlog = 0, sdlog = 1
)

# Same quartiles but with truncation at 10
qprimarycensored(
  c(0.25, 0.5, 0.75), plnorm,
  dprimary = dexpgrowth,
  dprimary_args = list(r = 0.2), meanlog = 0, sdlog = 1, D = 10
)
}
\seealso{
\code{\link[=new_pcens]{new_pcens()}} and \code{\link[=pcens_quantile]{pcens_quantile()}}

Primary event censored distribution functions
\code{\link{dprimarycensored}()},
\code{\link{pprimarycensored}()},
\code{\link{rprimarycensored}()}
}
\concept{primarycensored}
