% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmrs_ptp.R
\name{calculate_prms_2017_ptp}
\alias{calculate_prms_2017_ptp}
\title{Calculate 2017 PROMISE Minimal-Risk Score for obstructive CAD}
\usage{
calculate_prms_2017_ptp(
  age,
  sex,
  hdl_mg_dl,
  is_minority_ethnicity,
  have_diabetes,
  have_hypertension,
  have_dyslipidemia,
  have_smoking_history,
  have_family_history,
  have_stress_symptoms = NA,
  label_sex_male = c("male"),
  label_sex_female = c("female"),
  label_sex_unknown = c(NA, NaN),
  label_is_minority_ethnicity_no = c("no"),
  label_is_minority_ethnicity_yes = c("yes"),
  label_is_minority_ethnicity_unknown = c(NA, NaN),
  label_have_diabetes_no = c("no"),
  label_have_diabetes_yes = c("yes"),
  label_have_diabetes_unknown = c(NA, NaN),
  label_have_hypertension_no = c("no"),
  label_have_hypertension_yes = c("yes"),
  label_have_hypertension_unknown = c(NA, NaN),
  label_have_dyslipidemia_no = c("no"),
  label_have_dyslipidemia_yes = c("yes"),
  label_have_dyslipidemia_unknown = c(NA, NaN),
  label_have_smoking_history_no = c("no"),
  label_have_smoking_history_yes = c("yes"),
  label_have_smoking_history_unknown = c(NA, NaN),
  label_have_family_history_no = c("no"),
  label_have_family_history_yes = c("yes"),
  label_have_family_history_unknown = c(NA, NaN),
  label_have_stress_symptoms_no = c("no"),
  label_have_stress_symptoms_yes = c("yes"),
  label_have_stress_symptoms_unknown = c(NA, NaN)
)
}
\arguments{
\item{age}{Input numeric value to indicate the age of the patient in years.}

\item{sex}{The value of variable in the parameters \code{label_sex_male},
\code{label_sex_female} and \code{label_sex_unknown}.}

\item{hdl_mg_dl}{Input positive numeric value to indicate the
patient's high-density lipoprotein (HDL) in \eqn{mg/dL}.}

\item{is_minority_ethnicity}{The value of variable in the parameters
\code{label_is_minority_ethnicity_no}, \code{label_is_minority_ethnicity_yes}
and \code{label_is_minority_ethnicity_unknown}.}

\item{have_diabetes}{The value of variable in the parameters
\code{label_have_diabetes_no}, \code{label_have_diabetes_yes}
and \code{label_have_diabetes_unknown}.}

\item{have_hypertension}{The value of variable in the parameters
\code{label_have_hypertension_no}, \code{label_have_hypertension_yes}
and \code{label_have_hypertension_unknown}.}

\item{have_dyslipidemia}{The value of variable in the parameters
\code{label_have_dyslipidemia_no}, \code{label_have_dyslipidemia_yes}
and \code{label_have_dyslipidemia_unknown}.}

\item{have_smoking_history}{The value of variable in the parameters
\code{label_have_smoking_history_no}, \code{label_have_smoking_history_yes}
and \code{label_have_smoking_history_unknown}.}

\item{have_family_history}{The value of variable in the parameters
\code{label_have_family_history_no}, \code{label_have_family_history_yes}
and \code{label_have_family_history_unknown}.}

\item{have_stress_symptoms}{The value of variable in the parameters
\code{label_have_stress_symptoms_no}, \code{label_have_stress_symptoms_yes}
and \code{label_have_stress_symptoms_unknown}.
Default: \code{NA}}

\item{label_sex_male}{Label(s) for definition(s) of male sex.
Default: \code{c("male")}}

\item{label_sex_female}{Label(s) for definition(s) of female sex.
Default: \code{c("female")}}

\item{label_sex_unknown}{Label(s) for definition(s) of missing sex.
Default: \code{c(NA, NaN)}}

\item{label_is_minority_ethnicity_no}{Label(s) for patient not from a
racial or minority ethnicity (or patient is a non-Hispanic/Latino White).
Default: \code{c("no")}}

\item{label_is_minority_ethnicity_yes}{Label(s) for patient from a
racial or minority ethnicity (or patient is not a non-Hispanic/Latino White).
E.g. Blacks, Asians, etc.
Default: \code{c("yes")}}

\item{label_is_minority_ethnicity_unknown}{Label(s) for patient from an unknown ethnicity
Default: \code{c(NA, NaN)}}

\item{label_have_diabetes_no}{Label(s) for patient with no diabetes.
Default: \code{c("no")}}

\item{label_have_diabetes_yes}{Label(s) for patient having diabetes.
Default: \code{c("yes")}}

\item{label_have_diabetes_unknown}{Label(s) for patient
having unknown diabetes.
Default: \code{c(NA, NaN)}}

\item{label_have_hypertension_no}{Label(s) for patient with no hypertension.
Default: \code{c("no")}}

\item{label_have_hypertension_yes}{Label(s) for patient having hypertension.
Default: \code{c("yes")}}

\item{label_have_hypertension_unknown}{Label(s) for patient
having unknown hypertension.
Default: \code{c(NA, NaN)}}

\item{label_have_dyslipidemia_no}{Label(s) for patient with no dyslipidemia.
Default: \code{c("no")}}

\item{label_have_dyslipidemia_yes}{Label(s) for patient having dyslipidemia.
Default: \code{c("yes")}}

\item{label_have_dyslipidemia_unknown}{Label(s) for patient
having unknown dyslipidemia.
Default: \code{c(NA, NaN)}}

\item{label_have_smoking_history_no}{Label(s) for patient with
no smoking history (current or past).
Default: \code{c("no")}}

\item{label_have_smoking_history_yes}{Label(s) for patient having
smoking history (current or past).
Default: \code{c("yes")}}

\item{label_have_smoking_history_unknown}{Label(s) for patient
having unknown smoking history (current or past).
Default: \code{c(NA, NaN)}}

\item{label_have_family_history_no}{Label(s) for patient with no family history of CAD.
Default: \code{c("no")}}

\item{label_have_family_history_yes}{Label(s) for patient having family history of CAD.
Default: \code{c("yes")}}

\item{label_have_family_history_unknown}{Label(s) for patient
having unknown family history of CAD.
Default: \code{c(NA, NaN)}}

\item{label_have_stress_symptoms_no}{Label(s) for patient with
no symptoms (negative results) related to physical or mental stress.
Default: \code{c("no")}}

\item{label_have_stress_symptoms_yes}{Label(s) for patient with
symptoms (positive results) related to physical or mental stress.
Default: \code{c("yes")}}

\item{label_have_stress_symptoms_unknown}{Label(s) for patient with
inconclusive results or patient has not taken any stress test
Default: \code{c(NA, NaN)}}
}
\value{
A numeric value representing the patient's minimal risk
score for obstructive CAD based on the 2017 PROMISE Minimal-Risk Score.
}
\description{
This function returns
a symptomatic (have chest pain or dyspnoea) patient's
minimal risk score for obstructive
coronary artery disease based on the
2017 PROMISE Minimal-Risk Score.
}
\details{
The predictive model is based on CCTA images from 4632
patients in the Prospective Multicenter imaging Study for Evaluation
of Chest Pain (PROMISE) trial.
}
\examples{
# 50 year old white female with chest pain
# a medical history of hypertension, and a
# high-density lipoprotein cholesterol level of 70 mg/dL
calculate_prms_2017_ptp(
    age = 50,
    sex = "female",
    hdl_mg_dl = 70,
    is_minority_ethnicity = "no",
    have_diabetes = "no",
    have_hypertension = "yes",
    have_dyslipidemia = "no",
    have_smoking_history = "no",
    have_family_history = "no",
    have_stress_symptoms = "no"
)

# 40 year old non-white male with chest pain
# a medical history of diabetes, unknown stress symptoms and a
# high-density lipoprotein cholesterol level of 70 mg/dL
calculate_prms_2017_ptp(
    age = 40,
    sex = "male",
    hdl_mg_dl = 70,
    is_minority_ethnicity = "yes",
    have_diabetes = "yes",
    have_hypertension = "no",
    have_dyslipidemia = "no",
    have_smoking_history = "no",
    have_family_history = "no",
    have_stress_symptoms = NA
)
}
