% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepost_bounds.R
\name{prepost_sens}
\alias{prepost_sens}
\title{Run sensitivity analysis for the randomized moderator placement design}
\usage{
prepost_sens(
  formula,
  data,
  moderator,
  prepost,
  g_by,
  g_at,
  t_by,
  t_at,
  sims = 1000,
  stable_mod = FALSE,
  conf_level = 0.95,
  moderator_mono = NULL,
  outcome_mono = NULL,
  tau = 0.25,
  progress = TRUE,
  solver = "Rglpk"
)
}
\arguments{
\item{formula}{A formula with syntax \code{y ~ t}, where \code{y} is the
(unquoted) name of the outcome and \code{t} is the (unquoted) name of the treatment.}

\item{data}{A data.frame containing variables in the formula, moderator, and covariates arguments.}

\item{moderator}{A one-sided formuala with syntax \code{~ d}, where \code{d}
is the (unquoted) name of the  moderator variable for the CATE.}

\item{prepost}{A one-sided formula with syntax ~ z, where z is the indicator variable for whether the moderator was measured pre- or post-treatment.}

\item{g_by}{Numeric indicating the grid spacing for the
\eqn{\gamma} parameter that places an upper bound on the proportion
of units whose moderator is affected by treatment.}

\item{g_at}{Vector specifying what values to set the \eqn{\gamma} parameter
to in the sensitivity analysis. Overrides \code{g_by}.}

\item{t_by}{Numeric indicating the grid spacing for the
\eqn{\theta} parameter that restricts what proportion of units have
their outcomes affected by the pre vs post-measurement of the
moderator.}

\item{t_at}{Vector specifying what values to set the \eqn{\theta} parameter
to in the sensitivity analysis. Overrides \code{t_by}.}

\item{sims}{An integer indicating the number of simulations for the
bootstrap confidence intervals for the bounds.}

\item{stable_mod}{A logical value indicating if the bounds should
assume that the moderator is unaffected by pre-vs-post measurement
under the control condition.}

\item{conf_level}{A numeric indicating the confidence level for the
bootstrap confidence intervals.}

\item{moderator_mono}{A integer or vector of length 2 indicating
if the bounds should assume monotonicity of the effect of the
post-test on the moderator with \code{1} indicating that the post-test
effect is positive and \code{-1} indicating that it is negative. The
vector of length 2 allows the monotonicity assumption to vary by
treatment status with the first entry being for control and the
second for treated.}

\item{outcome_mono}{A integer or vector of length 2 indicating
if the bounds should assume monotonicity of the effect of the
post-test on the outcome with \code{1} indicating that the post-test
effect is positive and \code{-1} indicating that it is negative. The
vector of length 2 allows the monotonicity assumption to vary by
treatment status with the first entry being for control and the
second for treated.}

\item{tau}{A numeric indicating how close the the moment conditions of the
estimated bounds have to be from the minimum values in the sample. This
allows us to obtain bounds and confidence intevals even when the
assumptions are slightly violated due to sampling.}

\item{progress}{A logical indicating if progress bars should be
displayed. Defaults to TRUE.}

\item{solver}{A character indicating what linear programming solver to use:
"Rglpk" (the default) or "lpSolve".}
}
\value{
A list object containing sensitivity output.
}
\description{
Run sensitivity analysis for the randomized moderator placement design
}
\examples{
data(land_experiment)
prepost_sens(
  support ~ treat_comb,
  data = land_experiment,
  moderator = ~ land_insecure,
  prepost =  ~ prepost,
  g_by = 0.1,
  t_at = c(0.25, 1),
  sims = 50,
  moderator_mono = NULL
)
}
