% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dValueFunctions.R
\name{pi.d}
\alias{pi.d}
\title{\emph{d}-value (i.e., standardized mean difference) Prediction Interval}
\usage{
pi.d(d, n1, n2, rep.n1 = NA, rep.n2 = NA, prob.level = 0.95)
}
\arguments{
\item{d}{Original study: Sample \emph{d}-value (standardized mean difference) created with pooled variance denominator. See formulas 4.18 and 4.19 (p.26) in Borenstein, Hedges, Higgins, & Rothstein (2009).}

\item{n1}{Original study: Sample size for group 1}

\item{n2}{Original study: Sample size for group 2}

\item{rep.n1}{(optional) Replication study: Sample size for group 1. If not specified, n1 is used.}

\item{rep.n2}{(optional) Replication study: Sample size for group 2. If not specified, n2 is used.}

\item{prob.level}{(optional 0 to 1 value) Probability level desired (0 to 1). If not specified .95 (i.e., 95 percent) will be used.}
}
\value{
The prediction interval and related statistics in list format.
}
\description{
\emph{d}-value (i.e., standardized mean difference) Prediction Interval
}
\examples{
pi.d(d=.65,n1=50,n2=50,rep.n1=100,rep.n2=100)
}
\references{
Borenstein, M., Hedges, L. V., Higgins, J. P., & Rothstein, H. R. (2009). \emph{Introduction to meta-analysis}. John Wiley & Sons.\cr\cr
Cumming, G., & Finch, S. (2001). A primer on the understanding, use, and calculation of confidence intervals that are based on central and noncentral distributions. \emph{Educational and Psychological Measurement, 61(4)}, 532-574.
}

