\name{pweibull}
\alias{dpweibull}
\alias{ppweibull}
\alias{qpweibull}
\alias{rpweibull}

\title{
The Power Piecewise Weibull Distribution
}

\description{
Density, distribution function, quantile function, and random generation
for the power piecewise Weibull distribution.
}

\usage{
dpweibull(x, rate = 1, alpha = 1, t = 0, log = FALSE)

ppweibull(q, rate = 1, alpha = 1, t = 0, lower.tail = TRUE, log.p = FALSE)

qpweibull(p, rate = 1, alpha = 1, t = 0, lower.tail = TRUE, log.p = FALSE)

rpweibull(n = 1, rate = 1, alpha = 1, t = 0)
}

\arguments{
  \item{x}{
Vector of quantiles for the density function.
}

  \item{q}{
Vector of quantiles for the distribution function.
}

  \item{p}{
Vector of probabilities for the quantile function.
}

  \item{n}{
Number of observations to generate. If \code{length(n) > 1}, the length
is taken as the number of observations.
}

  \item{rate}{
A numeric vector of length \eqn{L} containing the rate parameters
\eqn{\lambda_1, \ldots, \lambda_L}.
}

  \item{alpha}{
A numeric vector of length \eqn{L} containing the shape parameters
\eqn{\alpha_1, \ldots, \alpha_L}.
}

  \item{t}{
A non-decreasing vector defining the time partition
\eqn{(0 = a_0, a_1, \ldots, a_L)}.
}

  \item{log}{
Logical; if \code{TRUE}, probabilities are returned on the log scale.
}

  \item{lower.tail}{
Logical; if \code{TRUE} (default), probabilities are
\eqn{P(T \le q)}; otherwise \eqn{P(T > q)}.
}

  \item{log.p}{
Logical; if \code{TRUE}, probabilities \code{p} are given on the log scale.
}
}

\details{
The hazard function of the power piecewise Weibull model is

\deqn{
h(t \mid \boldsymbol{\lambda}, \boldsymbol{\alpha})
  = \lambda_\ell \alpha_\ell t^{\alpha_\ell - 1},
  \qquad t \in (a_{\ell - 1}, a_\ell),\; \ell = 1, \ldots, L,
}

where \eqn{0 = a_0 < a_1 < \cdots < a_{L - 1} < a_L < \infty} defines the partition of time,
\eqn{\boldsymbol{\lambda} = (\lambda_1, \ldots, \lambda_L)}, and
\eqn{\boldsymbol{\alpha} = (\alpha_1, \ldots, \alpha_L)}.

Special cases include:

\itemize{
 \item \eqn{\alpha_1 = \cdots = \alpha_L = 1}:
       the piecewise exponential model (Feigl and Zelen, 1965; Friedman, 1982),
 \item \eqn{\alpha_1 = \cdots = \alpha_L = 2}:
       a piecewise Rayleigh model.
}
}

\value{
\code{dpweibull} returns the density,  
\code{ppweibull} returns the distribution function,  
\code{qpweibull} returns the quantile function, and  
\code{rpweibull} generates random deviates.

For \code{rpweibull}, the result has length \code{n}.  
For the other functions, the result has length equal to the maximum of the
lengths of the numerical arguments. Arguments are recycled as needed.

Only the first elements of the logical arguments \code{log}, \code{lower.tail},
and \code{log.p} are used.
}

\references{
Feigl P., Zelen M. (1965).  
Estimation of exponential survival probabilities with concomitant information.  
\emph{Biometrics}, \bold{21}, 826-838.

Friedman M. (1982).  
Piecewise exponential models for survival data with covariates.  
\emph{Annals of Statistics}, \bold{10}, 101-113.

Gomez Y. M., Gallardo D. I., Arnold B. C. (2018).  
The power piecewise exponential model.  
\emph{Journal of Statistical Computation and Simulation}, \bold{88}, 825-840.
}

\examples{
set.seed(3100)
## Random sample
rpweibull(n = 10, rate = c(0.05, 0.03), alpha = c(1, 1.5), t = c(0, 10))
## Distribution function
ppweibull(c(5, 10, 20), rate = c(0.05, 0.03), alpha = c(1, 1.5), t = c(0, 10))
}
