% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DominanceMatrix.R
\name{DominanceMatrix}
\alias{DominanceMatrix}
\title{Computing the dominance matrix.}
\usage{
DominanceMatrix(poset)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet}.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}
}
\value{
An \eqn{n\times n} boolean matrix \eqn{Z}, where \eqn{n} is the number of poset elements, with \eqn{Z[i,j]=TRUE},
if and only if the j-th poset element weakly dominates (\eqn{\leq}) the i-th element, in the input order relation.
}
\description{
Computes the dominance matrix of the input poset.
}
\examples{
elems <- c("a", "b", "c", "d")
dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = dom)

Z <- DominanceMatrix(pos)

}
