% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protein_quant.R
\name{rrollup}
\alias{rrollup}
\title{Applies rrollup function}
\usage{
rrollup(pepData, combine_fn, parallel = TRUE)
}
\arguments{
\item{pepData}{an omicsData object of class 'pepData'}

\item{combine_fn}{logical indicating what combine_fn to use, defaults to
median, other option is mean}

\item{parallel}{logical indicating whether or not to use "doParallel" loop in
applying rrollup function. Defaults to TRUE.}
}
\value{
an omicsData object of class 'proData'
}
\description{
This function applies the rrollup method to a pepData object for each unique
protein and returns a proData object.
}
\details{
In the rrollup method, peptides are scaled based on a reference
  peptide and protein abundance is set as the mean of these scaled peptides.
}
\references{
Matzke, M. M., Brown, J. N., Gritsenko, M. A., Metz, T. O.,
  Pounds, J. G., Rodland, K. D., ... Webb-Robertson, B.-J. (2013). \emph{A
  comparative analysis of computational approaches to relative protein
  quantification using peptide peak intensities in label-free LC-MS
  proteomics experiments}. Proteomics, 13(0), 493-503.

  Polpitiya, A. D., Qian, W.-J., Jaitly, N., Petyuk, V. A., Adkins, J. N.,
  Camp, D. G., ... Smith, R. D. (2008). \emph{DAnTE: a statistical tool for
  quantitative analysis of -omics data}. Bioinformatics (Oxford, England),
  24(13), 1556-1558.
}
