\name{plscale}
\alias{plscale}
\title{Generate Plscaled Plotting Scale
}
\description{Generates plscaled values and appropriate tick mark
  positions and labels for expressing a variable on a plscaled scale,
  e.g., on log scale
}
\usage{
plscale(x, plscale = "log10", ticksat = NULL, logscale = NULL,
  valuesonly = FALSE, ploptions = NULL)
}
\arguments{
  \item{x}{data to be used in plotting
  }
  \item{plscale}{name of the function defining the plscaled scale
  }
  \item{ticksat}{tick locations, If \code{NULL}, these locations will be
    generated by the function.
    An attribute \code{attr(..., "ticklabels")} may also be given.
  }
  \item{logscale}{if \code{NULL}, R's function \code{axTicks}
    will be called if the plscale is a log function.
  }
  \item{valuesonly}{logical: should only the transformed values be
    returned? Otherwise, axis ranges and tick information is also
    calculated.
  }
  \item{ploptions}{See \code{\link{ploptions}}
  }
}
\value{
  The \code{x} data is returned, augmented by the following attributes:
  \describe{
    \item{numvalues}{the plscaled values to be used for plotting}
    \item{ticksat}{the location of tick marks (plscaled values)}
    \item{ticklabels}{the labels for the tick marks showing the original
      scale}
    \item{plscale}{the name of the function used for the plscaleation}
  }
}
\author{Werner A. Stahel
}
\note{Besides the logarithmic plscale that is supported by core R
  graphics, any other plscaleation may be used, notably the so-called
  "first aid plscaleations".
}

\seealso{
  \code{\link{axTicks}, \link{prettyscale}}
}
\examples{
  x <- 10^seq(-1,3,0.5)
  plscale(x)
  xx <- plscale(x, plscale="sqrt")
  plyx(xx)
  x <- seq(0,100,2)
  plyx(plscale(x, plscale="asinp"), type="l") 
}
\keyword{dplot}

