% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_check.R
\name{error.check}
\alias{error.check}
\title{Checks for basic errors in input to the 'ple.lma' function}
\usage{
error.check(inData, model.type, inTraitAdj = NULL, inItemTraitAdj = NULL)
}
\arguments{
\item{inData}{Data frame with columns corresponding to categorical variables
and rows to the number of cases}

\item{model.type}{Type of model that will be fit to data}

\item{inTraitAdj}{Trait x Trait adjacency matrix (not required for independence)}

\item{inItemTraitAdj}{Item x Trait adjacency matrix (not required for independence)}
}
\value{
Message whether error was detected in input, and if so the nature of the error
}
\description{
This functions looks at the input to the main function (ple.lma) and checks
for 11 different possible errors. If an error is detected, the function
issues a warning and stops any further execution.  This funcion is internal
to 'ple.lma' but can be used outside of the wrapper function.
}
\examples{
 #--- some data
 data(dass)
 inData <- dass[1:250,c("d1", "d2", "d3", "a1","a2","a3","s1","s2","s3")]

 #--- no errors
 error.check(inData, model.type="independence")

 #--- for unidimensional
 inTraitAdj  <- matrix(1, nrow=1, ncol=1)
 inItemTraitAdj <- matrix(1, nrow=9, ncol=1)

 #--- no errors
 error.check(inData, model.type="rasch", inTraitAdj, inItemTraitAdj)
 error.check(inData, model.type="gpcm", inTraitAdj, inItemTraitAdj)
 error.check(inData, model.type="nominal", inTraitAdj, inItemTraitAdj)


}
