% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_dates.R
\name{guessDateFormat}
\alias{guessDateFormat}
\title{Determine Format of Date and Date-Time Variables}
\usage{
guessDateFormat(x)
}
\arguments{
\item{x}{character vector of dates or date-times}
}
\value{
Returns a character string representing the format of the date-time
variables.
}
\description{
Given a vector of dates or date-times, determine the format if one is used
consistently.  If inconsistentencies are found, the function will fail.
See \code{\link{strptime}} for examples of format specifications.
}
\details{
\code{guessDateFormat} is rigid when determining the date format.  For
date-times it expects the date and time parts to be separated by a space.  It
does not recognize all format specifications, such as the AM/PM indicator.  
The time part should have at least one colon to separate hours from minutes.
The date part may have any separator as non-numerical values are removed
before parsing.
}
\examples{
x <- c("2014-01-15", "20140202")
guessDateFormat(x)
}
\author{
Cole Beck
}
