% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_set_params}
\alias{pipe_set_params}
\title{Set pipeline parameters}
\usage{
pipe_set_params(pip, params, warnUndefined = TRUE)
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{params}{\code{list} of parameters to be set}

\item{warnUndefined}{\code{logical} whether to give a warning when trying
to set a parameter that is not defined in the pipeline.}
}
\value{
returns the \code{Pipeline} object invisibly
}
\description{
Set unbound function parameters defined in
the pipeline where 'unbound' means parameters that are not linked
to other steps. Trying to set parameters that don't exist in
the pipeline is ignored, by default, with a warning.
}
\examples{
p <- pipe_new("pipe", data = 1)
pipe_add(p, "add1", \(x = ~data, y = 2) x + y)
pipe_add(p, "add2", \(x = ~data, y = 3) x + y)
pipe_add(p, "mult", \(x = 4, z = 5) x * z)
pipe_get_params(p)
pipe_set_params(p, params = list(x = 3, y = 3))
pipe_get_params(p)
pipe_set_params(p, params = list(x = 5, z = 3))
pipe_get_params(p)

suppressWarnings(
  pipe_set_params(p, list(foo = 3)) # gives warning as 'foo' is undefined
)
pipe_set_params(p, list(foo = 3), warnUndefined = FALSE)
}
