% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulated_annealing_prochloro.R
\name{simulated_annealing_Prochloro}
\alias{simulated_annealing_Prochloro}
\title{Perform simulated annealing algorithm for samples with divinyl
chlorophyll and prochlorococcus. Chlorophyll must be the final column of
both S and F matrices, with Divinyl Chlorophyll a the 2nd to last column.
See how the example Sp and Fp matrices are organised.}
\usage{
simulated_annealing_Prochloro(
  S,
  Fmat = NULL,
  user_defined_min_max = NULL,
  do_matrix_checks = TRUE,
  niter = 500,
  step = 0.009,
  weight.upper.bound = 30,
  verbose = TRUE,
  seed = NULL,
  check_converge = 100
)
}
\arguments{
\item{S}{Sample data matrix – a matrix of pigment samples}

\item{Fmat}{Pigment to Chl a matrix}

\item{user_defined_min_max}{data frame with some format as min_max built-in data}

\item{do_matrix_checks}{This should only be set to TRUE when using the
default values. This will remove pigment columns that have column sums
of 0. Set to FALSE if using customised names for pigments and
phytoplankton groups}

\item{niter}{Number of iterations (default is 500)}

\item{step}{Step ratio used (default is 0.009)}

\item{weight.upper.bound}{Upper limit of the weights applied (default value is 30).}

\item{verbose}{Logical value. Output error and temperature at each
iteration. Default value of TRUE}

\item{seed}{Set seed number to reproduce the same results}

\item{check_converge}{TRUE/FALSE/integer; set the number of F matrices to
for convergence checking}
}
\value{
A list containing
\enumerate{
\item Fmat matrix
\item RMSE (Root Mean Square Error)
\item condition number
\item Class abundances
\item Figure (plot of results)
\item MAE (Mean Absolute Error)
\item Error
}
}
\description{
Perform simulated annealing algorithm for samples with divinyl
chlorophyll and prochlorococcus. Chlorophyll must be the final column of
both S and F matrices, with Divinyl Chlorophyll a the 2nd to last column.
See how the example Sp and Fp matrices are organised.
}
\examples{
# Using the built-in matrices Sp and Fp.
set.seed(5326)
sa.example <- simulated_annealing_Prochloro(Sp, Fp, niter = 1)
sa.example$Figure
}
