% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ladder.R
\name{ladder}
\alias{ladder}
\title{Reorder tree branches in ladderized pattern.}
\usage{
ladder(x, decreasing = FALSE)
}
\arguments{
\item{x}{an object of class \code{"dendrogram"}.}

\item{decreasing}{logical indicating whether the tree should be
ladderized upwards or downwards. Defaults to FALSE (downwards).}
}
\value{
Returns an object of class \code{dendrogram}.
}
\description{
This function ladderizes the branches of a \code{dendrogram} object
  to aid in visual interpretation.
}
\details{
This function is the \code{dendrogram} analogue of the
  \code{\link[ape]{ladderize}} function in the \code{\link[ape]{ape}}
  package (Paradis et al 2004, 2012).
}
\examples{
  x <- read.dendrogram(text = "(A:0.1,B:0.2,(C:0.3,D:0.4):0.5);")
  plot(x, horiz = TRUE)
  x <- ladder(x, decreasing = TRUE)
  plot(x, horiz = TRUE)
}
\references{
Paradis E, Claude J, Strimmer K, (2004) APE: analyses of phylogenetics
  and evolution in R language. \emph{Bioinformatics} \strong{20}, 289-290.

  Paradis E (2012) Analysis of Phylogenetics and Evolution with R
  (Second Edition). Springer, New York.
}
\seealso{
The \code{\link[ape]{ladderize}} function in the
  \code{\link[ape]{ape}} package performs a similar operation for objects
  of class \code{"phylo"}.
}
\author{
Shaun Wilkinson
}
