test_that("VIS waveband is correct for default", {
  expect_equal(VIS(), VIS("ISO"))
})

test_that("VIS waveband is correct for \"ISO\"", {
  wb <- VIS(std = "ISO")
  expect_equal(wl_range(wb), c(380, 760))
  expect_equal(wl_range(wb), range(VIS()))
  expect_equal(wl_range(wb), range(VIS("ISO")))
  expect_equal(labels(wb)$label, "VIS")
  expect_equal(labels(wb)$name, "VIS.ISO")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("VIS waveband is correct for \"RS\"", {
  wb <- VIS(std = "RS")
  expect_equal(wl_range(wb), c(400, 700))
  expect_equal(labels(wb)$label, "VIS")
  expect_equal(labels(wb)$name, "VIS.RS")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("VIS waveband is correct for \"LandsatOLI\"", {
  wb <- VIS(std = "LandsatOLI")
  expect_equal(wl_range(wb), c(500, 680))
  expect_equal(labels(wb)$label, "Pan")
  expect_equal(labels(wb)$name, "Pan.LandsatOLI")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("VIS waveband is correct for \"Landsat7\"", {
  wb <- VIS(std = "Landsat7")
  expect_equal(wl_range(wb), c(500, 900))
  expect_equal(labels(wb)$label, "Pan")
  expect_equal(labels(wb)$name, "Pan.Landsat7")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("VIS waveband is correct for \"LandsatRBV\"", {
  wb <- VIS(std = "LandsatRBV")
  expect_equal(wl_range(wb), c(505, 750))
  expect_equal(labels(wb)$label, "Pan")
  expect_equal(labels(wb)$name, "Pan.RBV.Landsat3")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("VIS waveband is correct for bad std", {
  expect_warning(wb <- VIS(std = "bad-std"))
  expect_equal(wl_range(wb), c(NA_real_, NA_real_))
  expect_equal(labels(wb)$label, "Not available")
  expect_equal(labels(wb)$name, "Not available")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_true(all(is.na(wb$hinges)))
  expect_equal(length(wb$hinges), 4L)
})
