% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-tuv-file.r
\name{qtuv_clouds}
\alias{qtuv_clouds}
\title{Clouds descriptor}
\usage{
qtuv_clouds(cloud.type = "clear.sky")
}
\arguments{
\item{cloud.type}{character One of "clear.sky", "cirrus", "stratocumulus" or
"overcast".}
}
\value{
A one-row data frame with members "optical.depth", "base", "top" and
  "label".
}
\description{
Constructor of a named list of parameter values to be used as argument to
parameter \code{clouds} of function \code{\link{qtuv_s.e.irrad}()}.
}
\details{
This function provide a rough approximation for parameter values.
  In reality there is large variation in the cloud optical depths (COD) and
  in the elevation at which clouds are located, within each type of cloud.
  The TUV model assumes a continuous uniform cloud layer, thus the normally
  discontinuous cover of cumulus clouds cannot be described.
}
\examples{

qtuv_clouds("clear.sky")
qtuv_clouds("cirrus")
qtuv_clouds(c("clear.sky", "cirrus"))

}
