% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm.beta.lmer.R
\name{lm.beta.lmer}
\alias{lm.beta.lmer}
\title{Obtain standardized regression coefficients from lmer model.}
\usage{
lm.beta.lmer(model)
}
\arguments{
\item{model}{name of \code{lmer()} model object.}
}
\value{
Standardized regression coefficients of \code{lmer()} model object.
}
\description{
Obtains standardized regression coefficients from the results of a model fit
by the \code{lme4()} function of the \code{lmer} package.
}
\details{
Obtains standardized regression coefficients from the results of a model fit
by the \code{lmer()} function of the \code{lme4} package.
}
\examples{
# Fit Model
library("lme4")

sleepstudy$DaySq <- sleepstudy$Days^2
model <- lme4::lmer(Reaction ~ Days + DaySq + (Days | Subject), sleepstudy)

# Standardized regression coefficients
lm.beta.lmer(model)

}
\seealso{
\url{https://stats.stackexchange.com/a/123448}

Other mixedModel: 
\code{\link{lmeSummary}()}
}
\concept{mixedModel}
