% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ucdp_acd.R
\name{add_ucdp_acd}
\alias{add_ucdp_acd}
\title{Add UCDP Armed Conflict Data to state-year data frame}
\usage{
add_ucdp_acd(data, type, issue, only_wars = FALSE)
}
\arguments{
\item{data}{state-year data frame}

\item{type}{the types of armed conflicts the user wants to consider, specified
as a character vector. Options include "extrasystemic", "interstate",
"intrastate", and "II". "II" is convenience shorthand for "internationalized
intrastate". If you want just one (say: "intrastate"), then the type you want
in quotes is sufficient. If you want multiple, wrap it in a vector with
\code{c()}.}

\item{issue}{do you want to subset the data to just different armed conflicts
over different types of issues? If so, specify those here as you would with
the \code{type} argument. Options include "territory", "government", and
"both". See Details note in this documentation for what "both" means.}

\item{only_wars}{subsets the conflict data to just those with intensity
levels of "war" (i.e. >1,000 deaths). Defaults to FALSE.}
}
\value{
\code{add_ucdp_acd()} takes a state-year data frame and returns
state-year information from the UCDP Armed Conflict data set (v. 25.1). The
variables returned are whether there is an ongoing armed conflict in that
year, whether there was an armed conflict episode onset that year, what was
the maximum intensity observed that year (if an armed conflict was observed),
and a character vector of the associated conflict IDs that year.
}
\description{
\code{add_ucdp_acd()} allows you to add UCDP Armed Conflict data
to a state-year data frame
}
\details{
Right now, only state-year data are supported.

It's worth saying that "both" in the \code{issue} argument should not be
understood as equivalent to \code{c("territory","government")}. The former is
a kind of "AND" (in boolean speak) and is an explicit category in the data.
The latter is an "OR" (in boolean speak) and is in all likelihood what you
want if you are tempted to specify "both" in the \code{issue} argument.
}
\examples{


# just call `library(tidyverse)` at the top of the your script.
library(magrittr)
library(dplyr)

create_stateyears(system = "gw", subset_years = c(1946:2024)) \%>\%
 add_ucdp_acd()

create_stateyears(system = "gw", subset_years = c(1946:2024)) \%>\%
 add_ucdp_acd(type = 'intrastate', issue = 'government')



}
\references{
Gleditsch, Nils Petter; Peter Wallensteen, Mikael Eriksson, Margareta
Sollenberg, and Havard Strand. 2002. "Armed Conflict 1946–2001: A New
Dataset." \emph{Journal of Peace Research} 39(5): 615–637.

Davies, Shawn, Therése PEttersson, Margareta Sollenberg, and Magnus Öberg.
2025. "Organized violence 1989–2024, and the challenges of identifying
civilian victims." \emph{Journal of Peace Research} 62(4): 1223--1240.
}
\author{
Steven V. Miller
}
