% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meandist.R
\name{pdMean}
\alias{pdMean}
\title{Weighted Karcher mean of HPD matrices}
\usage{
pdMean(M, w, metric = "Riemannian", grad_desc = FALSE, maxit = 1000, reltol)
}
\arguments{
\item{M}{a \eqn{(d,d,S)}-dimensional array corresponding to a sample of \eqn{(d,d)}-dimensional HPD matrices of
size \eqn{S}.}

\item{w}{an \eqn{S}-dimensional nonnegative weight vector, such that \code{sum(w) = 1}.}

\item{metric}{the distance measure, one of \code{'Riemannian'}, \code{'logEuclidean'},
\code{'Cholesky'}, \code{'Euclidean'} or \code{'rootEuclidean'}. Defaults to \code{'Riemannian'}.}

\item{grad_desc}{if \code{metric = "Riemannian"}, a logical value indicating if the
gradient descent algorithm in \insertCite{P06}{pdSpecEst} should be used, defaults to \code{FALSE}.}

\item{maxit}{maximum number of iterations in gradient descent algorithm, only used if
\code{grad_desc = TRUE} and \code{metric = "Riemannian"}. Defaults to \code{1000}}

\item{reltol}{optional tolerance parameter in gradient descent algorithm, only used if
\code{grad_desc = TRUE} and \code{metric = "Riemannian"}. Defaults to \code{1E-10}.}
}
\description{
\code{pdMean} calculates an (approximate) weighted Karcher or Frechet mean of a sample of
\eqn{(d,d)}-dimensional HPD matrices intrinsic to a user-specified metric. In the case of the
affine-invariant Riemannian metric as detailed in e.g., \insertCite{B09}{pdSpecEst}[Chapter 6] or
\insertCite{PFA05}{pdSpecEst}, the weighted Karcher mean is either approximated via
the fast recursive algorithm in \insertCite{H13}{pdSpecEst} or computed via the slower, but more accurate,
gradient descent algorithm in \insertCite{P06}{pdSpecEst}. By default, the unweighted Karcher mean is computed.
}
\note{
The function does not check for positive definiteness of the input matrices, and (depending on the
specified metric) may fail if matrices are close to being singular.
}
\examples{
## Generate random sample of HPD matrices
m <- function(){
 X <- matrix(complex(real=rnorm(9), imaginary=rnorm(9)), nrow=3)
 t(Conj(X)) \%*\% X
}
M <- replicate(100, m())
z <- rnorm(100)
## Generate random weight vector
w <- abs(z)/sum(abs(z))
## Compute weighted (Riemannian) Karcher mean
pdMean(M, w)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Mid}}, \code{\link{pdMedian}}
}
