% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcensmix.R
\name{pcgen}
\alias{pcgen}
\title{Creating a Progressively Type-II Censored Version of a Given Dataset}
\usage{
pcgen(r, p, data)
}
\arguments{
\item{r}{desired number of failures to observe.}

\item{p}{a parameter controlling the amount of censoring. The action of
censoring individuals after each failure occurs with probabilty \code{p}
from binomial distribution at each stage. If \code{p = 0}, no censoring
will happen.}

\item{data}{a numeric vector of a real dataset (mixture/not mixture) or an
object of class \code{data.frame} generated by
\code{\link[pcensmix]{mixgen}}.}
}
\value{
An object of class \code{"pcgen"} containing the following
  information: \item{original_data}{original mixture data}
  \item{label}{component membership indicator for the original simulated
  mixture data. This will not be returned if a real data has been used.}
  \item{censored_version_of_data}{progressive Type-II censored version of
  data, i.e., each observation is equal to the actual observed survival time
  in the event of failure and is equal to the latest observe failure time if
  it is associated to an unobserved censored observation. Notice that they
  are order statistics.} \item{component_indicator}{component indicator
  associated with the censored_verison_of_data. This will not be returned if
  a real data has been used.} \item{censoring_indicator}{censoring indicator
  associated with the censored_verison_of_data.}
}
\description{
This function implements an algorithm for generating a progressive Type-II
censored version of a specified dataset.
}
\details{
It creates a progressive Type-II censored version of a given real
  dataset or a simulated dataset from \code{\link[pcensmix]{mixgen}}. The
  output of this function can be passed as an argument to
  \code{\link[pcensmix]{pcensmixR}} or \code{\link[pcensmix]{pcensmixSim}} for the purpose of fitting a
  normal mixture model to the progressively censored dataset.
}
\note{
See \code{\link[pcensmix]{print.pcgen}} for printing data of class
\code{"pcgen"}.
}
\examples{
## 1. Generate a progressive Type-II censored data from a simulated mixture data with
## allowing for censoring with controlling parameters p = 0.3 and r = 12.
set.seed(0)
mixture <- mixgen(N = 20, dist1 = 'norm', dist2 = 'weibull', control = list(12, 2, 15, 4, 0.3))
Pdat0 <- pcgen(r = 12, p = 0.3, data = mixture)
print(Pdat0)


## 2. Examples of generating a progresively Type-II censored data

set.seed(0)
Pdat1 <- pcgen(r = 6, p = 0.3, data = insulate)
print(Pdat1)

set.seed(100)
Pdat2 <- pcgen(r = 260, p = 0.35, data = blood$Systolic.BP)
print(Pdat2)


}
\seealso{
\code{\link[pcensmix]{mixgen}}, \code{\link[pcensmix]{print.pcgen}}.
}
\author{
Lida Fallah, John Hinde

Maintainer: Lida Fallah <l.fallah22@gmail.com>
}
