% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract_features}
\alias{extract_features}
\title{Extract quantitative features from the continuous dorsal pattern of a female brown anole lizard}
\usage{
extract_features(data)
}
\arguments{
\item{data}{a \code{data.table} or \code{data.frame} object with three columns \code{x}, \code{y}, and \code{loc} in that order,
indicating the x-coordinate, the y-coordinate, and the location of a pixel (LEFT, RIGHT, or MID), respectively,
preferably from an output of \code{clean_patterns}. The xy-coordinates should be of type \code{"numeric"}, whereas the location should be of type \code{"character"} and capitalized.}
}
\value{
Returns a \code{data.table} object with the following columns:
\describe{
   \item{\code{lt_psi}, \code{rt_psi}}{left/right pattern sinuosity index (PSI), computed as \code{lt_len} / \code{md_len} and \code{rt_len} / \code{md_len}, respectively}
   \item{\code{av_psi}}{average pattern sinuosity index (PSI), (\code{ls_ind} + \code{rs_ind}) / 2}
   \item{\code{lt_pcv}, \code{rt_pcv}}{left/right pattern coefficient of variation (PCV), computed by dividing the standard deviation of the distance values between mid-dorsal axis and left/right pattern by the average distance.}
   \item{\code{av_pcv}}{average pattern coefficient of variation (PCV), (\code{lt_pcv} + \code{rt_pcv}) / 2}
   \item{\code{max_width}, \code{min_width}}{the maximum and the minimum width between the left and the right pattern}
   \item{\code{av_width}}{average width between the left and the right pattern}
   \item{\code{pmm}}{pattern max-min width (PMM), (\code{max_width} - \code{min_width}) / \code{av_width}}
   \item{\code{pasy}}{pattern asymmetry index (PASY), computed by first subtracting the distance between mid-dorsal axis and left pattern from the corresponding distance between mid-dorsal axis and right pattern and then taking the average of the resulting differences; the closer to zero it is, the more symmetric the dorsal pattern is on average}
   \item{\code{lt_len}, \code{rt_len}, \code{md_len}}{the length (the count of pixels) of the left pattern, the right pattern, and the mid-dorsal axis, respectively}
}
}
\description{
The function \code{extract_features} efficiently extracts various features
such as the pattern sinuosity indices, coefficient of variation, and max-min width
from the output of \code{clean_patterns}.
}
\details{
\code{extract_features} efficiently extracts common features from the continuous dorsal pattern of a female brown anole lizard, \emph{Anolis sagrei},
such as the pattern sinuosity indices, coefficient of variation, and max-min width.
The input data should either be a \code{data.table} or \code{data.frame} object with the columns indicating the xy-coordinates and the location of the pixels.
}
\examples{
# load the sample dorsal pattern image
data(anole)

# clean the dorsal pattern and extract quantitative features
features <- extract_features(clean_patterns(anole))

}
\author{
Seong Hyun Hwang, Rachel Myoung Moon
}
