% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{gather_tunnel_data}
\alias{gather_tunnel_data}
\title{Gather data columns into key-value pairs}
\usage{
gather_tunnel_data(obj_name, NA_drop = TRUE, ...)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}}

\item{NA_drop}{Should rows with NAs be dropped? Defaults to \code{TRUE}}

\item{...}{Additional arguments that can be passed to other \code{pathviewr}
functions such as \code{relabel_viewr_axes()} or \code{read_motive_csv()}}
}
\value{
A tibble in "tidy" format which is formatted to have every row
correspond to the position (and potentially rotation) of a single subject
during an observed frame and time. Subjects' names are automatically parsed
from original variable names (e.g. subject1_rotation_width extracts
"subject1" as the subject name) and stored in a \code{Subjects} column in the
returned tibble.
}
\description{
Reformat \code{viewr} data into a "tidy" format so that every row corresponds
to the position (and potentially rotation) of a single subject during an
observed frame and time.
}
\details{
The tibble or data.frame that is fed in must have variables that
have subject names and axis names separated by underscores. Axis names must
be one of the following: \code{position_length}, \code{position_width}, or
\code{position_height}. Each of these three dimensions must be present in the
data. Collectively, this means that names like \code{bird01_position_length}
or \code{larry_position_height} are acceptable, but \code{bird01_x} or
\code{bird01_length} are not.
}
\examples{
library(pathviewr)

## Import the Motive example data included in the package
motive_data <-
  read_motive_csv(system.file("extdata", "pathviewr_motive_example_data.csv",
                             package = 'pathviewr'))

## First use relabel_viewr_axes() to rename these variables using _length,
## _width, and _height instead
motive_data_relabeled <- relabel_viewr_axes(motive_data)

## Now use gather_tunnel_data() to gather colums into tidy format
motive_data_gathered <- gather_tunnel_data(motive_data_relabeled)

## Column names reflect the way in which data were reformatted:
names(motive_data_gathered)
}
\seealso{
Other data cleaning functions: 
\code{\link{get_full_trajectories}()},
\code{\link{quick_separate_trajectories}()},
\code{\link{redefine_tunnel_center}()},
\code{\link{relabel_viewr_axes}()},
\code{\link{rename_viewr_characters}()},
\code{\link{rotate_tunnel}()},
\code{\link{select_x_percent}()},
\code{\link{separate_trajectories}()},
\code{\link{standardize_tunnel}()},
\code{\link{trim_tunnel_outliers}()},
\code{\link{visualize_frame_gap_choice}()}
}
\author{
Vikram B. Baliga
}
\concept{data cleaning functions}
