% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{clean_by_span}
\alias{clean_by_span}
\title{Remove file_sub_traj entries that do not span the full region of interest}
\usage{
clean_by_span(
  obj_name,
  axis = "position_length",
  min_value = NULL,
  max_value = NULL,
  tolerance = 0.1
)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}}

\item{axis}{Along which axis should restrictions be enforced?}

\item{min_value}{Minimum coordinate value; setting this to NULL will
auto-compute the best value}

\item{max_value}{Maximum coordinate; setting this to NULL will auto-compute
the best value}

\item{tolerance}{As a proporiton of axis value}
}
\value{
A viewr object (tibble or data.frame with attribute
\code{pathviewr_steps}. Trajectories that do not span the full region of
interest have been removed; trajectory identities (file_sub_traj) have
not been changed.
}
\description{
Remove file_sub_traj entries that do not span the full region of interest
}
\seealso{
Other utility functions: 
\code{\link{insert_treatments}()},
\code{\link{remove_duplicate_frames}()},
\code{\link{remove_vel_anomalies}()},
\code{\link{set_traj_frametime}()}
}
\author{
Vikram B. Baliga
}
\concept{utility functions}
