% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshapeData.R
\name{reshapeData}
\alias{reshapeData}
\title{Reorganize longitudinal microbiome into a data cube ready for PARAFAC modelling.}
\usage{
reshapeData(
  Xlong,
  subjectMetadata,
  featureMetadata,
  timepointMetadata,
  timepointOrder = sort(unique(timepointMetadata))
)
}
\arguments{
\item{Xlong}{Longitudinal microbiome count data in matrix (long) format.}

\item{subjectMetadata}{Vector containing the subjects corresponding to the measurements in Xlong.}

\item{featureMetadata}{Taxonomic classification of the microbiota, ordered the same as the columns in Xlong.}

\item{timepointMetadata}{Vector containing the time points corresponding to the measurements in Xlong.}

\item{timepointOrder}{Vector containing the required order of the timepoints in timepointMetadata (default: sort(unique(timepointMetadata)) ).}
}
\value{
#' A list object containing \describe{
\item{data}{Array object of the data cube}
\item{mode1}{Dataframe with the subjects, ordered the same as the rows in the data cube.}
\item{mode2}{Taxonomic classification of the microbiota, ordered the same as the columns in the data cube.}
\item{mode3}{Dataframe with the time metadata, ordered the same as the third dimension in the data cube.}
...
}
}
\description{
Reorganize longitudinal microbiome into a data cube ready for PARAFAC modelling.
}
\examples{
library(dplyr)

Xlong = array(rnorm(108*5*10), c(108*5, 10))
subjects = rep(1:108, 5)
features = rep(1:10)
timepoints = rep(1:5, each=108)

dataset = reshapeData(Xlong, subjects, features, timepoints)
}
