% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_design_lhs.R
\name{generate_design_lhs}
\alias{generate_design_lhs}
\title{Generate a Space-Filling LHS Design}
\usage{
generate_design_lhs(param_set, n, lhs_fun = NULL)
}
\arguments{
\item{param_set}{(\code{\link{ParamSet}}).}

\item{n}{(\code{integer(1)}) \cr
Number of points to sample.}

\item{lhs_fun}{(\verb{function(n, k)})\cr
Function to use to generate a LHS sample, with n samples and k values per param.
LHS functions are implemented in package \pkg{lhs}, default is to use \code{\link[lhs:maximinLHS]{lhs::maximinLHS()}}.}
}
\value{
\code{\link{Design}}.
}
\description{
Generate a space-filling design using Latin hypercube sampling. Dependent
parameters whose constraints are unsatisfied generate \code{NA} entries in
their respective columns.
}
\examples{
pset = ps(
  ratio = p_dbl(lower = 0, upper = 1),
  letters = p_fct(levels = letters[1:3])
)

if (requireNamespace("lhs", quietly = TRUE)) {
  generate_design_lhs(pset, 10)
}
}
\seealso{
Other generate_design: 
\code{\link{generate_design_grid}()},
\code{\link{generate_design_random}()},
\code{\link{generate_design_sobol}()}
}
\concept{generate_design}
