% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{nobs.wbm}
\alias{nobs.wbm}
\title{Number of observations used in \code{wbm} models}
\usage{
\method{nobs}{wbm}(object, entities = TRUE, ...)
}
\arguments{
\item{object}{a fitted model object.}

\item{entities}{Should \code{nobs} return the number of entities in the panel
or the number of rows in the \code{panel_data} frame? Default is TRUE, returning
the number of entities.}

\item{...}{further arguments to be passed to methods.}
}
\description{
This S3 method allows you to retrieve either the number of
observations or number of entities in the data used to fit \code{wbm} objects.
}
\examples{
data("WageData")
wages <- panel_data(WageData, id = id, wave = t)
model <- wbm(lwage ~ lag(union) + wks, data = wages)
nobs(model)
}
