% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{ohvbd.ids}
\alias{ohvbd.ids}
\title{Create a new ohvbd ID vector}
\usage{
ohvbd.ids(ids, db)
}
\arguments{
\item{ids}{A numeric vector of ids referring to datasets within the specified database.}

\item{db}{A string specifying the database that these ids refer to.}
}
\value{
An id vector: an S3 vector with class \code{ohvbd.ids}.
}
\description{
When retrieving data from previous searches (or saved lists of IDs), it can
be useful to package these data up in the form that ohvbd would expect to
come out of a search.

To do this, create an \code{ohvbd.ids} object, specifying the database that the ids refer to.
}
\examples{
ohvbd.ids(c(1,2,3,4,5), db="vt")

ohvbd.ids(c(1,2,3,4,5), db="vd")

ohvbd.ids(
  c(
    "dbc4a3ae-680f-44e6-ab25-c70e27b38dbc",
    "fac87892-68c8-444a-9ae9-46273fdff724"
    ),
  db="gbif"
)
}
\author{
Francis Windram
}
