% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocsApiSharingManager.R
\docType{class}
\name{ocsApiSharingManager}
\alias{ocsApiSharingManager}
\title{ocsApiSharingManager}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ocsManager for the Sharing API
}
\description{
ocsApiSharingManager

ocsApiSharingManager
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{manager}
\keyword{ocs}
\keyword{sharing}
\section{Super classes}{
\code{\link[ocs4R:ocs4RLogger]{ocs4R::ocs4RLogger}} -> \code{\link[ocs4R:ocsManager]{ocs4R::ocsManager}} -> \code{ocsApiSharingManager}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ocsApiSharingManager-new}{\code{ocsApiSharingManager$new()}}
\item \href{#method-ocsApiSharingManager-getShares}{\code{ocsApiSharingManager$getShares()}}
\item \href{#method-ocsApiSharingManager-createShare}{\code{ocsApiSharingManager$createShare()}}
\item \href{#method-ocsApiSharingManager-shareWithUser}{\code{ocsApiSharingManager$shareWithUser()}}
\item \href{#method-ocsApiSharingManager-shareWithGroup}{\code{ocsApiSharingManager$shareWithGroup()}}
\item \href{#method-ocsApiSharingManager-shareAsPublicLink}{\code{ocsApiSharingManager$shareAsPublicLink()}}
\item \href{#method-ocsApiSharingManager-clone}{\code{ocsApiSharingManager$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocs4RLogger" data-id="ERROR"><a href='../../ocs4R/html/ocs4RLogger.html#method-ocs4RLogger-ERROR'><code>ocs4R::ocs4RLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocs4RLogger" data-id="INFO"><a href='../../ocs4R/html/ocs4RLogger.html#method-ocs4RLogger-INFO'><code>ocs4R::ocs4RLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocs4RLogger" data-id="WARN"><a href='../../ocs4R/html/ocs4RLogger.html#method-ocs4RLogger-WARN'><code>ocs4R::ocs4RLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocs4RLogger" data-id="getClass"><a href='../../ocs4R/html/ocs4RLogger.html#method-ocs4RLogger-getClass'><code>ocs4R::ocs4RLogger$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocs4RLogger" data-id="getClassName"><a href='../../ocs4R/html/ocs4RLogger.html#method-ocs4RLogger-getClassName'><code>ocs4R::ocs4RLogger$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocs4RLogger" data-id="logger"><a href='../../ocs4R/html/ocs4RLogger.html#method-ocs4RLogger-logger'><code>ocs4R::ocs4RLogger$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocsManager" data-id="connect"><a href='../../ocs4R/html/ocsManager.html#method-ocsManager-connect'><code>ocs4R::ocsManager$connect()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocsManager" data-id="getAPISharingManager"><a href='../../ocs4R/html/ocsManager.html#method-ocsManager-getAPISharingManager'><code>ocs4R::ocsManager$getAPISharingManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocsManager" data-id="getAPIUserProvisioningManager"><a href='../../ocs4R/html/ocsManager.html#method-ocsManager-getAPIUserProvisioningManager'><code>ocs4R::ocsManager$getAPIUserProvisioningManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocsManager" data-id="getAPIWebdavManager"><a href='../../ocs4R/html/ocsManager.html#method-ocsManager-getAPIWebdavManager'><code>ocs4R::ocsManager$getAPIWebdavManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocsManager" data-id="getCapabilities"><a href='../../ocs4R/html/ocsManager.html#method-ocsManager-getCapabilities'><code>ocs4R::ocsManager$getCapabilities()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocsManager" data-id="getVersion"><a href='../../ocs4R/html/ocsManager.html#method-ocsManager-getVersion'><code>ocs4R::ocsManager$getVersion()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ocsApiSharingManager-new"></a>}}
\if{latex}{\out{\hypertarget{method-ocsApiSharingManager-new}{}}}
\subsection{Method \code{new()}}{
Initialize manager
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ocsApiSharingManager$new(url, user, pwd, logger = NULL, keyring_backend = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{url}

\item{\code{user}}{user}

\item{\code{pwd}}{pwd}

\item{\code{logger}}{logger}

\item{\code{keyring_backend}}{backend to use with \pkg{keyring}. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ocsApiSharingManager-getShares"></a>}}
\if{latex}{\out{\hypertarget{method-ocsApiSharingManager-getShares}{}}}
\subsection{Method \code{getShares()}}{
Get list of shares as \code{list}. To return as \code{data.frame}, 
set \code{pretty = TRUE}. The method accepts additional parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ocsApiSharingManager$getShares(
  path = NULL,
  reshares = FALSE,
  shared_with_me = NULL,
  state = NULL,
  subfiles = FALSE,
  pretty = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path}

\item{\code{reshares}}{reshares}

\item{\code{shared_with_me}}{list only those shared with me?}

\item{\code{state}}{state}

\item{\code{subfiles}}{subfiles}

\item{\code{pretty}}{pretty}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the list of shares as \code{list} or \code{data.frame}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ocsApiSharingManager-createShare"></a>}}
\if{latex}{\out{\hypertarget{method-ocsApiSharingManager-createShare}{}}}
\subsection{Method \code{createShare()}}{
Creates a share for the path (file or folder), given a name. The \code{shareType} should be among
   values 'user','group','publiclink' or 'federated'.The \code{shareWith} is required for \code{shareType} 
   'user' and 'group' and corresponds to the username or groupname. The \code{permissions} can be set among
   values 'read', 'update', 'create', 'delete', 'read-write', 'share', 'all'. By default the permissions will 
   be the default permissions set by the ocs server (by default 'all').
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ocsApiSharingManager$createShare(
  path,
  name,
  shareType,
  shareWith,
  publicUpload = NULL,
  password = NULL,
  permissions = NULL,
  expireDate = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path}

\item{\code{name}}{name}

\item{\code{shareType}}{the type of share}

\item{\code{shareWith}}{a list of users to share with}

\item{\code{publicUpload}}{public upload}

\item{\code{password}}{to set to access the share}

\item{\code{permissions}}{permissions}

\item{\code{expireDate}}{expire date}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ocsApiSharingManager-shareWithUser"></a>}}
\if{latex}{\out{\hypertarget{method-ocsApiSharingManager-shareWithUser}{}}}
\subsection{Method \code{shareWithUser()}}{
Shares a resource (file or folder) with a user given its username handled with argument \code{username}. 
  The \code{permissions} can be set among values 'read', 'update', 'create', 'delete', 'read-write', 'share', 
  'all'. By default the permissions will be the default permissions set by the ocs server (by default 'all').
  Returns
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ocsApiSharingManager$shareWithUser(
  path,
  name,
  username,
  permissions = NULL,
  pretty = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path}

\item{\code{name}}{name}

\item{\code{username}}{username}

\item{\code{permissions}}{permissions}

\item{\code{pretty}}{pretty}

\item{\code{group}}{group}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the share properties as \code{list} (or as\code{data.frame} if \code{pretty} is set to TRUE).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ocsApiSharingManager-shareWithGroup"></a>}}
\if{latex}{\out{\hypertarget{method-ocsApiSharingManager-shareWithGroup}{}}}
\subsection{Method \code{shareWithGroup()}}{
Shares a resource (file or folder) with a group given its name handled with argument \code{group}. 
  The \code{permissions} can be set among values 'read', 'update', 'create', 'delete', 'read-write', 'share', 
  'all'. By default the permissions will be the default permissions set by the ocs server (by default 'all').
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ocsApiSharingManager$shareWithGroup(
  path,
  name,
  group,
  permissions = NULL,
  pretty = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path}

\item{\code{name}}{name}

\item{\code{group}}{group}

\item{\code{permissions}}{permissions}

\item{\code{pretty}}{pretty}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the share properties as \code{list} (or as\code{data.frame} if \code{pretty} is set to TRUE).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ocsApiSharingManager-shareAsPublicLink"></a>}}
\if{latex}{\out{\hypertarget{method-ocsApiSharingManager-shareAsPublicLink}{}}}
\subsection{Method \code{shareAsPublicLink()}}{
Shares a resource (file or folder) as public link. The function returns the public link generated by ocs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ocsApiSharingManager$shareAsPublicLink(
  path,
  name = NULL,
  publicUpload = FALSE,
  password = NULL,
  permissions = NULL,
  expireDate = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path}

\item{\code{name}}{name}

\item{\code{publicUpload}}{public upload?}

\item{\code{password}}{password}

\item{\code{permissions}}{permissions}

\item{\code{expireDate}}{expire date}

\item{\code{return}}{the public sharing link}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ocsApiSharingManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ocsApiSharingManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ocsApiSharingManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
